"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mappingsWithPropsApiLogic = exports.getMappings = exports.MappingsApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappings = async ({
  indexName,
  http
}) => {
  const route = `/internal/content_connectors/mappings/${indexName}`;
  return await (http === null || http === void 0 ? void 0 : http.get(route));
};
exports.getMappings = getMappings;
const mappingsWithPropsApiLogic = indexName => (0, _create_api_logic.createApiLogic)(['mappings_api_logic_with_props', indexName], getMappings);
exports.mappingsWithPropsApiLogic = mappingsWithPropsApiLogic;
const MappingsApiLogic = exports.MappingsApiLogic = (0, _create_api_logic.createApiLogic)(['mappings_api_logic'], getMappings);