"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityOverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _fp = require("lodash/fp");
var _helpers = require("@kbn/cloud-security-posture/src/utils/helpers");
var _findings_flyout = require("../../configurations/findings_flyout/findings_flyout");
var _nvd_logo_svg = require("../../../assets/icons/nvd_logo_svg");
var _get_vector_score_list = require("../utils/get_vector_score_list");
var _redhat_logo = _interopRequireDefault(require("../../../assets/icons/redhat_logo.svg"));
var _vulnerability_detection_rule_counter = require("./vulnerability_detection_rule_counter");
var _copy_button = require("../../../components/copy_button");
var _overview_tab = require("../../configurations/findings_flyout/overview_tab");
var _vulnerability_id_content = require("./vulnerability_id_content");
var _test_subjects = require("../test_subjects");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cvssVendors = {
  nvd: 'NVD',
  redhat: 'Red Hat',
  ghsa: 'GHSA'
};
const vendorIcons = {
  redhat: _redhat_logo.default,
  ghsa: 'logoGithub'
};
const EMPTY_VALUE = '-';
const CVSScore = ({
  vectorBaseScore,
  vendor
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const vendorName = cvssVendors[vendor];
  const vectorScores = (0, _get_vector_score_list.getVectorScoreList)(vectorBaseScore);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        border: 1px solid ${euiTheme.border.color};
        border-radius: 6px;
        padding: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
          width: 116px;
          font-weight: 600;
          display: flex;
          flex-direction: row;
          align-items: center;
        `
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
            margin-right: 30px;
          `
  }, vendor === 'nvd' ? (0, _nvd_logo_svg.NvdLogo)() : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: vendorIcons[vendor],
    size: "xl"
  })), /*#__PURE__*/_react2.default.createElement("span", null, vendorName)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, vectorScores.length > 0 && vectorScores.map((vectorScore, i) => /*#__PURE__*/_react2.default.createElement(VectorScore, {
    key: `${vectorScore}-${i}`,
    vectorScore: vectorScore
  }))));
};
const VectorScore = ({
  vectorScore
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    score,
    vector,
    version
  } = vectorScore;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          background: ${euiTheme.colors.backgroundLightText};
          padding: ${euiTheme.size.xs} ${euiTheme.size.s};
          border-radius: 6px;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-size: ${euiTheme.size.m};
              color: ${euiTheme.colors.textParagraph};
            `
  }, vector, ' ')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, score && /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    score: score,
    version: version
  }))));
};
const emptyFixesMessageState = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityOverviewTab.emptyFixesMessage', {
  defaultMessage: 'No available fixes yet.'
});
const renderFixedBySection = (vulnerabilityRecord, euiTheme) => {
  var _vulnerabilityRecord$;
  const renderFinding = (item, i, field, object) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react.css)`
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
          `
  }, item)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_copy_button.CopyButton, {
    copyText: item
  })));
  const renderPackageField = field => {
    const value = (0, _fp.get)(field, vulnerabilityRecord);
    if (!value) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs"
      }, EMPTY_VALUE);
    }
    return Array.isArray(value) ? /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
      items: value,
      field: `package.${field}`,
      object: vulnerabilityRecord,
      renderItem: renderFinding
    }) : value;
  };
  if (!(vulnerabilityRecord !== null && vulnerabilityRecord !== void 0 && (_vulnerabilityRecord$ = vulnerabilityRecord.package) !== null && _vulnerabilityRecord$ !== void 0 && _vulnerabilityRecord$.fixed_version)) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, emptyFixesMessageState);
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.packageTitle",
    defaultMessage: "Package"
  }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderPackageField('package.name')))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: {
      marginBottom: euiTheme.size.xxs
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    css: (0, _react.css)`
                  font-weight: ${euiTheme.font.weight.medium};
                `,
    id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.versionTitle",
    defaultMessage: "Version"
  }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderPackageField('package.fixed_version')))));
};
const getVulnerabilityScoreList = vulnerabilityData => {
  var _renderCvssScores;
  return [{
    title: '',
    description: vulnerabilityData ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l",
      css: (0, _react.css)`
          margin-top: '4px'};
        `
    }, !!((_renderCvssScores = renderCvssScores(vulnerabilityData.vulnerability)) !== null && _renderCvssScores !== void 0 && _renderCvssScores.length) ? renderCvssScores(vulnerabilityData.vulnerability) : EMPTY_VALUE) : EMPTY_VALUE
  }];
};
const getResourceList = vulnerabilityData => {
  var _vulnerabilityData$re, _vulnerabilityData$re2, _vulnerabilityData$pa, _vulnerabilityData$pa2;
  return [{
    title: '',
    description: vulnerabilityData ? /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasBorder: true
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBasicTable, {
      "data-test-subj": _test_subjects.VULNERABILITY_RESOURCE_TABLE,
      items: (0, _overview_tab.convertObjectToArray)({
        ID: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$re = vulnerabilityData.resource) === null || _vulnerabilityData$re === void 0 ? void 0 : _vulnerabilityData$re.id,
        Name: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$re2 = vulnerabilityData.resource) === null || _vulnerabilityData$re2 === void 0 ? void 0 : _vulnerabilityData$re2.name,
        Package: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$pa = vulnerabilityData.package) === null || _vulnerabilityData$pa === void 0 ? void 0 : _vulnerabilityData$pa.name,
        Version: vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$pa2 = vulnerabilityData.package) === null || _vulnerabilityData$pa2 === void 0 ? void 0 : _vulnerabilityData$pa2.version
      }) || [],
      rowHeader: "Field",
      columns: _overview_tab.columns
    }))) : EMPTY_VALUE
  }];
};
const getDetailsList = (vulnerabilityData, euiTheme) => {
  var _vulnerabilityData$vu, _vulnerabilityData$vu2, _vulnerabilityData$vu3;
  return [{
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", null, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.alertsTitle', {
      defaultMessage: 'Alerts'
    }))),
    description: (_vulnerabilityData$vu = vulnerabilityData.vulnerability) !== null && _vulnerabilityData$vu !== void 0 && _vulnerabilityData$vu.id ? /*#__PURE__*/_react2.default.createElement(_vulnerability_detection_rule_counter.VulnerabilityDetectionRuleCounter, {
      vulnerabilityRecord: vulnerabilityData
    }) : EMPTY_VALUE
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", null, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.cveTitle', {
      defaultMessage: 'CVE'
    }))),
    description: /*#__PURE__*/_react2.default.createElement(_vulnerability_id_content.VulnerabilityIdContent, {
      vulnerability: vulnerabilityData.vulnerability
    })
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", null, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.publishedTitle', {
      defaultMessage: 'Published'
    }))),
    description: (_vulnerabilityData$vu2 = vulnerabilityData.vulnerability) !== null && _vulnerabilityData$vu2 !== void 0 && _vulnerabilityData$vu2.published_date ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.publishedDateText",
      defaultMessage: "{date}",
      values: {
        date: vulnerabilityData.vulnerability.published_date
      }
    }) : EMPTY_VALUE
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", null, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.descriptionTitle', {
      defaultMessage: 'Description'
    }))),
    description: /*#__PURE__*/_react2.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, (vulnerabilityData === null || vulnerabilityData === void 0 ? void 0 : (_vulnerabilityData$vu3 = vulnerabilityData.vulnerability) === null || _vulnerabilityData$vu3 === void 0 ? void 0 : _vulnerabilityData$vu3.description) || EMPTY_VALUE)
  }, {
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: {
        marginBottom: euiTheme.size.xs
      }
    }, /*#__PURE__*/_react2.default.createElement("h1", null, _i18n.i18n.translate('xpack.csp.findings.vulnerabilityFindingsFlyout.overviewTab.fixedByTitle', {
      defaultMessage: 'Fixed by'
    }))),
    description: renderFixedBySection(vulnerabilityData, euiTheme)
  }];
};
const renderCvssScores = vulnerability => {
  if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.cvss)) return [];
  return Object.entries(vulnerability.cvss).map(([vendor, vectorScoreBase]) => {
    if (cvssVendors[vendor]) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        key: vendor
      }, /*#__PURE__*/_react2.default.createElement(CVSScore, {
        vectorBaseScore: vectorScoreBase,
        vendor: vendor
      }));
    }
    return null;
  }).filter(Boolean); // Filter out any `undefined` values
};
const VulnerabilityOverviewTab = ({
  vulnerabilityRecord
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.VULNERABILITIES_FLYOUT_VISITS);
  const accordions = (0, _react2.useMemo)(() => [{
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.aboutTitle', {
      defaultMessage: 'About'
    }),
    id: 'detailsAccordion',
    listItems: getDetailsList(vulnerabilityRecord, euiTheme)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.resourceTitle', {
      defaultMessage: 'Resource'
    }),
    id: 'resourceAccordion',
    listItems: getResourceList(vulnerabilityRecord)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.vulnerabilitiesFindingFlyout.overviewTab.vulnerabilityScoreTitle', {
      defaultMessage: 'Vulnerability Score'
    }),
    id: 'vulnerabilityScoreAccordion',
    listItems: getVulnerabilityScoreList(vulnerabilityRecord)
  }].filter(_helpers.truthy), [euiTheme, vulnerabilityRecord]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, accordions.map(accordion => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, {
    key: accordion.id
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: accordion.id,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react2.default.createElement("strong", null, accordion.title)),
    arrowDisplay: "left",
    initialIsOpen: accordion.initialIsOpen
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m",
    listItems: accordion.listItems
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, null))));
};
exports.VulnerabilityOverviewTab = VulnerabilityOverviewTab;