"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpandableFlyoutCsp = void 0;
var _react = require("react");
var _security_solution_context = require("../../application/security_solution_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExpandableFlyoutCsp = (flyoutType = 'misconfiguration') => {
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const securitySolutionContext = (0, _react.useContext)(_security_solution_context.SecuritySolutionContext);
  const setFlyoutCloseCallback = (0, _react.useCallback)(onChange => {
    // Check if the context and required methods exist
    if (securitySolutionContext && securitySolutionContext.useOnExpandableFlyoutClose) {
      securitySolutionContext.useOnExpandableFlyoutClose({
        callback: () => onChange(undefined)
      });
    }
  }, [securitySolutionContext]);
  if (!securitySolutionContext || !securitySolutionContext.useExpandableFlyoutApi) return {
    onExpandDocClick: null
  };
  const {
    openFlyout,
    closeFlyout
  } = securitySolutionContext.useExpandableFlyoutApi();
  setFlyoutCloseCallback(setExpandedDoc);
  const onExpandDocClick = record => {
    let finding;
    if (record) {
      if (flyoutType === 'vulnerability') {
        var _record$raw, _finding, _finding$vulnerabilit, _finding2, _finding2$resource, _finding3, _finding3$package, _finding4, _finding4$package, _finding5, _finding5$event;
        finding = record === null || record === void 0 ? void 0 : (_record$raw = record.raw) === null || _record$raw === void 0 ? void 0 : _record$raw._source;
        setExpandedDoc(record);
        openFlyout({
          right: {
            id: 'findings-vulnerability-panel',
            params: {
              vulnerabilityId: (_finding = finding) === null || _finding === void 0 ? void 0 : (_finding$vulnerabilit = _finding.vulnerability) === null || _finding$vulnerabilit === void 0 ? void 0 : _finding$vulnerabilit.id,
              resourceId: (_finding2 = finding) === null || _finding2 === void 0 ? void 0 : (_finding2$resource = _finding2.resource) === null || _finding2$resource === void 0 ? void 0 : _finding2$resource.id,
              packageName: (_finding3 = finding) === null || _finding3 === void 0 ? void 0 : (_finding3$package = _finding3.package) === null || _finding3$package === void 0 ? void 0 : _finding3$package.name,
              packageVersion: (_finding4 = finding) === null || _finding4 === void 0 ? void 0 : (_finding4$package = _finding4.package) === null || _finding4$package === void 0 ? void 0 : _finding4$package.version,
              eventId: (_finding5 = finding) === null || _finding5 === void 0 ? void 0 : (_finding5$event = _finding5.event) === null || _finding5$event === void 0 ? void 0 : _finding5$event.id
            }
          }
        });
      } else {
        var _record$raw2;
        finding = record === null || record === void 0 ? void 0 : (_record$raw2 = record.raw) === null || _record$raw2 === void 0 ? void 0 : _record$raw2._source;
        setExpandedDoc(record);
        openFlyout({
          right: {
            id: 'findings-misconfiguration-panel',
            params: {
              resourceId: finding.resource.id,
              ruleId: finding.rule.id
            }
          }
        });
      }
    } else {
      closeFlyout();
      setExpandedDoc(undefined);
    }
  };
  return {
    expandedDoc,
    setExpandedDoc,
    onExpandDocClick
  };
};
exports.useExpandableFlyoutCsp = useExpandableFlyoutCsp;