"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourcePreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _error = require("../../../../canvas_plugin_src/renderers/error");
var _datatable = require("../../datatable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Error = (0, _public.withSuspense)(_error.LazyErrorComponent);
const strings = {
  getEmptyFirstLineDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptyFirstLineDescription', {
    defaultMessage: "We couldn't find any documents matching your search criteria."
  }),
  getEmptySecondLineDescription: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptySecondLineDescription', {
    defaultMessage: 'Check your datasource settings and try again.'
  }),
  getEmptyTitle: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.emptyTitle', {
    defaultMessage: 'No documents found'
  }),
  getModalTitle: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.modalTitle', {
    defaultMessage: 'Datasource preview'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.datasourceDatasourcePreview.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
const DatasourcePreview = ({
  done,
  datatable
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: done,
    maxWidth: "1000px",
    className: "canvasModal--fixedSize"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, strings.getModalTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    className: "canvasDatasourcePreview"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.canvas.datasourceDatasourcePreview.modalDescription",
    defaultMessage: "The following data will be available to the selected element upon clicking {saveLabel} in the sidebar.",
    values: {
      saveLabel: /*#__PURE__*/_react.default.createElement("strong", null, strings.getSaveButtonLabel())
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), datatable.type === 'error' ? /*#__PURE__*/_react.default.createElement(Error, {
    payload: datatable
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "canvasDatasourcePreview__panel",
    paddingSize: "none"
  }, datatable.rows.length > 0 ? /*#__PURE__*/_react.default.createElement(_datatable.Datatable, {
    datatable: datatable,
    showHeader: true,
    paginate: true
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, strings.getEmptyTitle()),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement("p", null, strings.getEmptyFirstLineDescription(), /*#__PURE__*/_react.default.createElement("br", null), strings.getEmptySecondLineDescription())
  }))));
};
exports.DatasourcePreview = DatasourcePreview;
DatasourcePreview.propTypes = {
  datatable: _propTypes.default.object,
  done: _propTypes.default.func
};