"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorManager = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _color_dot = require("../color_dot/color_dot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAddAriaLabel: () => _i18n.i18n.translate('xpack.canvas.colorManager.addAriaLabel', {
    defaultMessage: 'Add Color'
  }),
  getCodePlaceholder: () => _i18n.i18n.translate('xpack.canvas.colorManager.codePlaceholder', {
    defaultMessage: 'Color code'
  }),
  getRemoveAriaLabel: () => _i18n.i18n.translate('xpack.canvas.colorManager.removeAriaLabel', {
    defaultMessage: 'Remove Color'
  })
};
const ColorManager = ({
  hasButtons = false,
  onAddColor,
  onChange,
  onRemoveColor,
  value = ''
}) => {
  const validColor = _chromaJs.default.valid(value);
  let buttons = null;
  if (hasButtons) {
    buttons = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": strings.getAddAriaLabel(),
      iconType: "plusInCircle",
      isDisabled: !validColor || !onAddColor,
      onClick: () => onAddColor && onAddColor(value)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": strings.getRemoveAriaLabel(),
      iconType: "minusInCircle",
      isDisabled: !validColor || !onRemoveColor,
      onClick: () => onRemoveColor && onRemoveColor(value)
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_color_dot.ColorDot, {
    value: validColor ? value : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'inline-block'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: value,
    isInvalid: !validColor && value.length > 0,
    placeholder: strings.getCodePlaceholder(),
    onChange: e => onChange(e.target.value)
  })), buttons);
};
exports.ColorManager = ColorManager;
ColorManager.propTypes = {
  hasButtons: _propTypes.default.bool,
  onAddColor: _propTypes.default.func,
  onChange: _propTypes.default.func.isRequired,
  onRemoveColor: _propTypes.default.func,
  value: _propTypes.default.string
};