"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategorizationGraph = getCategorizationGraph;
var _langgraph = require("@langchain/langgraph");
var _graph = require("../../util/graph");
var _samples = require("../../util/samples");
var _categorization = require("./categorization");
var _constants = require("./constants");
var _errors = require("./errors");
var _invalid = require("./invalid");
var _review = require("./review");
var _validate = require("./validate");
var _stable = require("./stable");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  rawSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  samples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  ecsTypes: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  ecsCategories: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  stableSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  reviewCount: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 0
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  previousError: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  pipelineResults: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => [{}]
  },
  previousPipelineResults: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => [{}]
  },
  lastReviewedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  currentPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  currentProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  invalidCategorization: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  previousInvalidCategorization: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  initialPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  samplesFormat: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({
      name: 'unsupported'
    })
  }
};
function modelInput({
  state
}) {
  let samples;
  if (state.samplesFormat.name === 'json' || state.samplesFormat.name === 'ndjson') {
    samples = (0, _samples.prefixSamples)(state);
  } else {
    samples = state.rawSamples;
  }
  const initialPipeline = JSON.parse(JSON.stringify(state.currentPipeline));
  return {
    exAnswer: JSON.stringify(_constants.CATEGORIZATION_EXAMPLE_ANSWER, null, 2),
    ecsCategories: JSON.stringify(_constants.ECS_CATEGORIES, null, 2),
    ecsTypes: JSON.stringify(_constants.ECS_TYPES, null, 2),
    samples,
    initialPipeline,
    stableSamples: [],
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput({
  state
}) {
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      docs: state.pipelineResults,
      pipeline: state.currentPipeline
    }
  };
}
function validationRouter({
  state
}) {
  if (Object.keys(state.currentProcessors).length === 0) {
    if (state.stableSamples.length === state.pipelineResults.length) {
      return 'modelOutput';
    }
    return 'categorization';
  }
  return 'validateCategorization';
}
function chainRouter({
  state
}) {
  if (Object.keys(state.currentProcessors).length === 0) {
    if (state.stableSamples.length === state.pipelineResults.length) {
      return 'modelOutput';
    }
  }
  if (Object.keys(state.errors).length > 0) {
    return 'errors';
  }
  if (Object.keys(state.invalidCategorization).length > 0) {
    return 'invalidCategorization';
  }
  if (state.stableSamples.length < state.pipelineResults.length && state.reviewCount < _constants2.CATEGORIZATION_REVIEW_MAX_CYCLES) {
    return 'review';
  }
  return 'modelOutput';
}
async function getCategorizationGraph({
  client,
  model
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addNode('handleCategorization', state => (0, _categorization.handleCategorization)({
    state,
    model
  })).addNode('handleValidatePipeline', state => (0, _graph.handleValidatePipeline)({
    state,
    client
  })).addNode('handleUpdateStableSamples', state => (0, _stable.handleUpdateStableSamples)({
    state
  })).addNode('handleCategorizationValidation', state => (0, _validate.handleCategorizationValidation)({
    state
  })).addNode('handleInvalidCategorization', state => (0, _invalid.handleInvalidCategorization)({
    state,
    model
  })).addNode('handleErrors', state => (0, _errors.handleErrors)({
    state,
    model
  })).addNode('handleReview', state => (0, _review.handleReview)({
    state,
    model
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('modelInput', 'handleValidatePipeline').addEdge('handleCategorization', 'handleCategorizationValidation').addEdge('handleInvalidCategorization', 'handleValidatePipeline').addEdge('handleErrors', 'handleValidatePipeline').addEdge('handleReview', 'handleValidatePipeline').addEdge('handleValidatePipeline', 'handleUpdateStableSamples').addConditionalEdges('handleUpdateStableSamples', state => validationRouter({
    state
  }), {
    modelOutput: 'modelOutput',
    categorization: 'handleCategorization',
    validateCategorization: 'handleCategorizationValidation'
  }).addConditionalEdges('handleCategorizationValidation', state => chainRouter({
    state
  }), {
    modelOutput: 'modelOutput',
    errors: 'handleErrors',
    invalidCategorization: 'handleInvalidCategorization',
    review: 'handleReview'
  });
  const compiledCategorizationGraph = workflow.compile();
  return compiledCategorizationGraph;
}