"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallItem = WaterfallItem;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_plugin_context = require("../../../../../../context/apm_plugin/use_apm_plugin_context");
var _agent_name = require("../../../../../../../common/agent_name");
var _apm = require("../../../../../../../common/es_fields/apm");
var _formatters = require("../../../../../../../common/utils/formatters");
var _use_apm_params = require("../../../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../../../hooks/use_apm_router");
var _truncate_with_tooltip = require("../../../../../shared/truncate_with_tooltip");
var _cold_start_badge = require("./badge/cold_start_badge");
var _span_links_badge = require("./badge/span_links_badge");
var _sync_badge = require("./badge/sync_badge");
var _failure_badge = require("./failure_badge");
var _orphan_item_tooltip_icon = require("./orphan_item_tooltip_icon");
var _span_missing_destination_tooltip = require("./span_missing_destination_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styled.default.div`
  position: relative;
  display: block;
  user-select: none;
  min-height: 44px;
  padding-top: ${({
  theme
}) => theme.euiTheme.size.s};
  padding-bottom: ${({
  theme
}) => theme.euiTheme.size.m};
  margin-right: ${props => props.timelineMargins.right}px;
  margin-left: ${props => props.hasToggle ? props.timelineMargins.left - 21 // fix margin if there is a toggle (toggle width is 20px)
: props.timelineMargins.left}px;
  background-color: ${({
  isSelected,
  theme
}) => isSelected ? theme.euiTheme.colors.lightestShade : 'initial'};
  cursor: ${props => props.hasOnClick ? 'pointer' : 'default'}};

  &:hover {
    background-color: ${({
  theme
}) => theme.euiTheme.colors.lightestShade};
  }
`;
const ItemBar = _styled.default.div`
  box-sizing: border-box;
  position: relative;
  height: ${({
  theme
}) => theme.euiTheme.size.base};
  min-width: 2px;
  background-color: ${props => props.color};
`;
const ItemText = _styled.default.span`
  position: absolute;
  right: 0;
  display: flex;
  align-items: center;
  height: ${({
  theme
}) => theme.euiTheme.size.l};
  max-width: 100%;

  /* add margin to all direct descendants */
  & > * {
    margin-right: ${({
  theme
}) => theme.euiTheme.size.s};
    white-space: nowrap;
  }
`;
const CriticalPathItemBar = _styled.default.div`
  box-sizing: border-box;
  position: relative;
  height: ${({
  theme
}) => theme.euiTheme.size.s};
  top: ${({
  theme
}) => theme.euiTheme.size.s};
  min-width: 2px;
  background-color: transparent;
  display: flex;
  flex-direction: row;
`;
const CriticalPathItemSegment = _styled.default.div`
  box-sizing: border-box;
  position: absolute;
  height: ${({
  theme
}) => theme.euiTheme.size.s};
  left: ${props => props.left * 100}%;
  width: ${props => props.width * 100}%;
  min-width: 2px;
  background-color: ${props => props.color};
`;
function PrefixIcon({
  item
}) {
  switch (item.docType) {
    case 'span':
      {
        const spanType = item.doc.span.type || '';

        // icon for database spans
        const isDbType = spanType.startsWith('db');
        if (isDbType) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "database"
          });
        }

        // omit icon for other spans
        return null;
      }
    case 'transaction':
      {
        // icon for RUM agent transactions
        if ((0, _agent_name.isRumAgentName)(item.doc.agent.name)) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "globe"
          });
        }

        // icon for other transactions
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "merge"
        });
      }
    default:
      return null;
  }
}
function SpanActionToolTip({
  item,
  children
}) {
  if ((item === null || item === void 0 ? void 0 : item.docType) === 'span') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${item.doc.span.subtype}.${item.doc.span.action}`
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
}
function Duration({
  item
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, (0, _formatters.asDuration)(item.duration));
}
function HttpStatusCode({
  item
}) {
  // http status code for transactions of type 'request'
  const httpStatusCode = item.docType === 'transaction' && item.doc.transaction.type === 'request' ? item.doc.transaction.result : undefined;
  if (!httpStatusCode) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, httpStatusCode);
}
function NameLabel({
  item
}) {
  switch (item.docType) {
    case 'span':
      let name = item.doc.span.name;
      if (item.doc.span.composite) {
        const compositePrefix = item.doc.span.composite.compression_strategy === 'exact_match' ? 'x' : '';
        name = `${item.doc.span.composite.count}${compositePrefix} ${name}`;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: {
          overflow: 'hidden'
        },
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        content: name,
        text: name
      }));
    case 'transaction':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xxs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, item.doc.transaction.name));
  }
}
function WaterfallItem({
  timelineMargins,
  totalDuration,
  item,
  hasToggle,
  color,
  isSelected,
  errorCount,
  getRelatedErrorsHref,
  marginLeftLevel,
  onClick,
  segments,
  isEmbeddable = false
}) {
  var _item$doc$faas;
  const [widthFactor, setWidthFactor] = (0, _react.useState)(1);
  const waterfallItemRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (waterfallItemRef !== null && waterfallItemRef !== void 0 && waterfallItemRef.current && marginLeftLevel) {
      setWidthFactor(1 + marginLeftLevel / waterfallItemRef.current.offsetWidth);
    }
  }, [marginLeftLevel]);
  if (!totalDuration) {
    return null;
  }
  const width = item.duration / totalDuration * widthFactor * 100;
  const left = ((item.offset + item.skew) / totalDuration * widthFactor - widthFactor + 1) * 100;
  const isCompositeSpan = item.docType === 'span' && item.doc.span.composite;
  const itemBarStyle = getItemBarStyle(item, color, width, left);
  const isServerlessColdstart = item.docType === 'transaction' && ((_item$doc$faas = item.doc.faas) === null || _item$doc$faas === void 0 ? void 0 : _item$doc$faas.coldstart);
  const waterfallItemFlyoutTab = 'metadata';
  const itemName = item.docType === 'transaction' ? item.doc.transaction.name : item.doc.span.name;
  return /*#__PURE__*/_react.default.createElement(Container, {
    ref: waterfallItemRef,
    type: item.docType,
    timelineMargins: timelineMargins,
    isSelected: isSelected,
    hasToggle: hasToggle,
    "data-test-subj": "waterfallItem",
    onKeyDown: e => {
      if (onClick && (e.key === 'Enter' || e.key === ' ')) {
        // Ignore event if it comes from a link
        if (e.target instanceof HTMLAnchorElement) {
          return;
        }
        e.preventDefault(); // Prevent scroll if Space is pressed
        onClick(item.id);
      }
    },
    tabIndex: onClick ? 0 : -1,
    role: onClick ? 'button' : undefined,
    "aria-label": onClick ? _i18n.i18n.translate('xpack.apm.waterfall.openDetailsButton', {
      defaultMessage: 'View details for {name}',
      values: {
        name: itemName
      }
    }) : undefined,
    onClick: e => {
      if (onClick) {
        e.stopPropagation();
        onClick(waterfallItemFlyoutTab);
      }
    },
    hasOnClick: onClick !== undefined
  }, /*#__PURE__*/_react.default.createElement(ItemBar // using inline styles instead of props to avoid generating a css class for each item
  , {
    style: itemBarStyle,
    color: isCompositeSpan ? 'transparent' : color,
    type: item.docType
  }, segments !== null && segments !== void 0 && segments.length ? /*#__PURE__*/_react.default.createElement(CriticalPathItemBar, null, segments === null || segments === void 0 ? void 0 : segments.map(segment => /*#__PURE__*/_react.default.createElement(CriticalPathItemSegment, {
    key: segment.id,
    color: segment.color,
    left: segment.left,
    width: segment.width
  }))) : null), /*#__PURE__*/_react.default.createElement(ItemText // using inline styles instead of props to avoid generating a css class for each item
  , {
    style: {
      minWidth: `${Math.max(100 - left, 0)}%`
    }
  }, /*#__PURE__*/_react.default.createElement(SpanActionToolTip, {
    item: item
  }, /*#__PURE__*/_react.default.createElement(PrefixIcon, {
    item: item
  })), item.isOrphan ? /*#__PURE__*/_react.default.createElement(_orphan_item_tooltip_icon.OrphanItemTooltipIcon, {
    docType: item.docType
  }) : null, item.missingDestination ? /*#__PURE__*/_react.default.createElement(_span_missing_destination_tooltip.SpanMissingDestinationTooltip, null) : null, /*#__PURE__*/_react.default.createElement(HttpStatusCode, {
    item: item
  }), /*#__PURE__*/_react.default.createElement(NameLabel, {
    item: item
  }), /*#__PURE__*/_react.default.createElement(Duration, {
    item: item
  }), isEmbeddable ? /*#__PURE__*/_react.default.createElement(EmbeddableRelatedErrors, {
    item: item,
    errorCount: errorCount,
    getRelatedErrorsHref: getRelatedErrorsHref
  }) : /*#__PURE__*/_react.default.createElement(RelatedErrors, {
    item: item,
    errorCount: errorCount
  }), item.docType === 'span' && /*#__PURE__*/_react.default.createElement(_sync_badge.SyncBadge, {
    sync: item.doc.span.sync,
    agentName: item.doc.agent.name
  }), /*#__PURE__*/_react.default.createElement(_span_links_badge.SpanLinksBadge, {
    linkedParents: item.spanLinksCount.linkedParents,
    linkedChildren: item.spanLinksCount.linkedChildren,
    id: item.id,
    onClick: onClick
  }), isServerlessColdstart && /*#__PURE__*/_react.default.createElement(_cold_start_badge.ColdStartBadge, null)));
}
function EmbeddableRelatedErrors({
  item,
  errorCount,
  getRelatedErrorsHref
}) {
  var _item$doc$event;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const viewRelatedErrorsLabel = _i18n.i18n.translate('xpack.apm.waterfall.embeddableRelatedErrors.errorCount', {
    defaultMessage: '{errorCount, plural, one {View related error} other {View # related errors}}',
    values: {
      errorCount
    }
  });
  if (errorCount > 0 && getRelatedErrorsHref) {
    return (
      /*#__PURE__*/
      // eslint-disable-next-line @elastic/eui/href-or-on-click
      _react.default.createElement(_eui.EuiBadge, {
        color: euiTheme.colors.danger,
        iconType: "arrowRight",
        href: getRelatedErrorsHref(item.id),
        onClick: e => {
          e.stopPropagation();
        },
        tabIndex: 0,
        role: "button",
        "aria-label": viewRelatedErrorsLabel,
        onClickAriaLabel: viewRelatedErrorsLabel
      }, viewRelatedErrorsLabel)
    );
  }
  return /*#__PURE__*/_react.default.createElement(_failure_badge.FailureBadge, {
    outcome: (_item$doc$event = item.doc.event) === null || _item$doc$event === void 0 ? void 0 : _item$doc$event.outcome
  });
}
function RelatedErrors({
  item,
  errorCount
}) {
  var _item$doc$transaction, _item$doc$span, _item$doc$event2;
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer', '/dependencies/operation');
  const {
    core: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  let kuery = `${_apm.TRACE_ID} : "${item.doc.trace.id}"`;
  const transactionId = (_item$doc$transaction = item.doc.transaction) === null || _item$doc$transaction === void 0 ? void 0 : _item$doc$transaction.id;
  const spanId = (_item$doc$span = item.doc.span) === null || _item$doc$span === void 0 ? void 0 : _item$doc$span.id;
  if (item.docType === 'transaction' && spanId) {
    kuery += ` and ${_apm.SPAN_ID} : "${spanId}"`;
  } else if (transactionId) {
    kuery += ` and ${_apm.TRANSACTION_ID} : "${transactionId}"`;
  }
  const mobileHref = apmRouter.link(`/mobile-services/{serviceName}/errors-and-crashes`, {
    path: {
      serviceName: item.doc.service.name
    },
    query: {
      ...query,
      serviceGroup: '',
      kuery
    }
  });
  const href = apmRouter.link(`/services/{serviceName}/errors`, {
    path: {
      serviceName: item.doc.service.name
    },
    query: {
      ...query,
      serviceGroup: '',
      kuery
    }
  });
  const viewRelatedErrorsLabel = _i18n.i18n.translate('xpack.apm.waterfall.errorCount', {
    defaultMessage: '{errorCount, plural, one {View related error} other {View # related errors}}',
    values: {
      errorCount
    }
  });
  const onClick = e => {
    e.stopPropagation();
    navigateToUrl((0, _agent_name.isMobileAgentName)(item.doc.agent.name) ? mobileHref : href);
  };
  if (errorCount > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: euiTheme.colors.danger,
      iconType: "arrowRight",
      onClick: onClick,
      tabIndex: 0,
      role: "button",
      "aria-label": viewRelatedErrorsLabel,
      onClickAriaLabel: viewRelatedErrorsLabel
    }, viewRelatedErrorsLabel);
  }
  return /*#__PURE__*/_react.default.createElement(_failure_badge.FailureBadge, {
    outcome: (_item$doc$event2 = item.doc.event) === null || _item$doc$event2 === void 0 ? void 0 : _item$doc$event2.outcome
  });
}
function getItemBarStyle(item, color, width, left) {
  let itemBarStyle = {
    left: `${left}%`,
    width: `${width}%`
  };
  if (item.docType === 'span' && item.doc.span.composite) {
    const percNumItems = 100.0 / item.doc.span.composite.count;
    const spanSumRatio = item.doc.span.composite.sum.us / item.doc.span.duration.us;
    const percDuration = percNumItems * spanSumRatio;
    itemBarStyle = {
      ...itemBarStyle,
      ...{
        backgroundImage: `repeating-linear-gradient(90deg, ${color},` + ` ${color} max(${percDuration}%,3px),` + ` transparent max(${percDuration}%,3px),` + ` transparent max(${percNumItems}%,max(${percDuration}%,3px) + 3px))`
      }
    };
  }
  return itemBarStyle;
}