"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRequiredGroupInDefaultActions = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateRequiredGroupInDefaultActions = ({
  actions,
  isSystemAction
}) => {
  const defaultActions = actions.filter(action => !isSystemAction(action.id));
  for (const action of defaultActions) {
    if (!action.group) {
      throw _boom.default.badRequest(`Group is not defined in action ${action.id}`);
    }
  }
};
exports.validateRequiredGroupInDefaultActions = validateRequiredGroupInDefaultActions;