"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHorizontalRuleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHorizontalRuleStyles = exports.euiHorizontalRuleStyles = function euiHorizontalRuleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiHorizontalRule: /*#__PURE__*/(0, _react.css)("border:none;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          ".concat((0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), "\n          background-color: ").concat(euiTheme.border.color, ";\n        "),
      // Windows high contrast themes ignore background colors
      forced: (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin)
    }), "flex-shrink:0;flex-grow:0;;label:euiHorizontalRule;"),
    // Sizes
    full: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:full;"),
    half: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '50%'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";;label:half;"),
    quarter: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '25%'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";;label:quarter;"),
    // Margins
    none: '',
    xs: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.s, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.m, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.xl, ";;label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.xxl, ";;label:xxl;")
  };
};