"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDescribedFormGroupStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDescribedFormGroupStyles = exports.euiDescribedFormGroupStyles = function euiDescribedFormGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = (0, _form.euiFormMaxWidth)(euiThemeContext);
  return {
    euiDescribedFormGroup: /*#__PURE__*/(0, _react.css)("&+*{", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.l), ";};label:euiDescribedFormGroup;"),
    // Skip css`` to avoid generating an Emotion className
    formWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', (0, _global_styling.mathWithUnits)(formMaxWidth, function (x) {
      return x * 2;
    })), "\n    "),
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), ";;label:fullWidth;"),
    euiDescribedFormGroup__descriptionColumn: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 'min(20rem, 50%)'), ";;label:euiDescribedFormGroup__descriptionColumn;"),
    euiDescribedFormGroup__description: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', euiTheme.size.s), ";;label:euiDescribedFormGroup__description;"),
    euiDescribedFormGroup__fields: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', 0), "&>.euiFormRow:first-child:not(.euiFormRow--hasLabel){&::before{content:'';}}&>.euiFormRow--hasEmptyLabelSpace:first-child{", (0, _global_styling.logicalCSS)('margin-top', 0), ";};label:euiDescribedFormGroup__fields;")
  };
};