"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogger = void 0;
exports.getMetadataListRequestHandler = getMetadataListRequestHandler;
exports.getMetadataRequestHandler = void 0;
exports.getMetadataTransformStatsHandler = getMetadataTransformStatsHandler;
var _common = require("@kbn/fleet-plugin/common");
var _stringify = require("../../utils/stringify");
var _error_handler = require("../error_handler");
var _constants = require("../../../../common/endpoint/constants");
var _package_v = require("../../../../common/endpoint/utils/package_v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogger = endpointAppContext => {
  return endpointAppContext.logFactory.get('metadata');
};
exports.getLogger = getLogger;
function getMetadataListRequestHandler(endpointAppContext, logger) {
  return async (context, request, response) => {
    logger.debug(() => `endpoint host metadata list request:\n${(0, _stringify.stringify)(request.query)}`);
    const spaceId = (await context.securitySolution).getSpaceId();
    const endpointMetadataService = endpointAppContext.service.getEndpointMetadataService(spaceId);
    try {
      const {
        data,
        total
      } = await endpointMetadataService.getHostMetadataList(request.query);
      const body = {
        data,
        total,
        page: request.query.page || _constants.ENDPOINT_DEFAULT_PAGE,
        pageSize: request.query.pageSize || _constants.ENDPOINT_DEFAULT_PAGE_SIZE,
        sortField: request.query.sortField || _constants.ENDPOINT_DEFAULT_SORT_FIELD,
        sortDirection: request.query.sortDirection || _constants.ENDPOINT_DEFAULT_SORT_DIRECTION
      };
      return response.ok({
        body
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
}
const getMetadataRequestHandler = function (endpointAppContext, logger) {
  return async (context, request, response) => {
    const spaceId = (await context.securitySolution).getSpaceId();
    const endpointMetadataService = endpointAppContext.service.getEndpointMetadataService(spaceId);
    try {
      return response.ok({
        body: await endpointMetadataService.getEnrichedHostMetadata(request.params.id)
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
};
exports.getMetadataRequestHandler = getMetadataRequestHandler;
function getMetadataTransformStatsHandler(endpointAppContext, logger) {
  return async (context, _, response) => {
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    const packageClient = endpointAppContext.service.getInternalFleetServices().packages;
    const installation = await packageClient.getInstallation(_common.FLEET_ENDPOINT_PACKAGE);
    const transformName = installation !== null && installation !== void 0 && installation.version && !(0, _package_v.isEndpointPackageV2)(installation.version) ? _constants.METADATA_TRANSFORMS_PATTERN : _constants.METADATA_TRANSFORMS_PATTERN_V2;
    try {
      const transformStats = await esClient.transform.getTransformStats({
        transform_id: transformName,
        allow_no_match: true
      });
      return response.ok({
        body: transformStats
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
}