"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExplorePartialIndexMappingResponder = void 0;
var _zod = require("@kbn/zod");
var _langgraph = require("@langchain/langgraph");
var _messages = require("@langchain/core/messages");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const structuredOutput = _zod.z.object({
  containsRequiredFieldsForQuery: _zod.z.boolean().describe('Whether the index pattern contains the required fields for the query')
});
const getExplorePartialIndexMappingResponder = async ({
  createLlmInstance
}) => {
  const llm = await createLlmInstance();
  return async state => {
    const {
      messages
    } = state;
    const lastMessage = messages[messages.length - 1];
    const result = await llm.withStructuredOutput(structuredOutput, {
      name: 'indexMappingAnalysis'
    }).invoke([new _messages.SystemMessage({
      content: 'You are an expert at parsing text. You have been given a text and need to parse it into the provided schema.'
    }), new _messages.HumanMessage({
      content: lastMessage.content
    })]);
    return new _langgraph.Command({
      update: {
        output: {
          containsRequiredFieldsForQuery: result.containsRequiredFieldsForQuery,
          context: JSON.stringify((0, _utils.buildContext)(messages))
        }
      }
    });
  };
};
exports.getExplorePartialIndexMappingResponder = getExplorePartialIndexMappingResponder;