"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineWrapper = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _modal = require("../components/modal");
var _use_selector = require("../../common/hooks/use_selector");
var _bottom_bar = require("../components/bottom_bar");
var _selectors = require("../store/selectors");
var _use_timeline_save_prompt = require("../../common/hooks/timeline/use_timeline_save_prompt");
var _store = require("../store");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component renders the timeline EuiPortal as well as the bottom bar, and handles the interaction between the two.
 * Using EuiFocusTrap, we can trap the focus within the portal when it is open, which prevents closing the portal when clicking outside of it.
 */
const TimelineWrapper = exports.TimelineWrapper = /*#__PURE__*/_react.default.memo(({
  timelineId,
  onAppLeave
}) => {
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, timelineId));
  const dispatch = (0, _reactRedux.useDispatch)();
  const openToggleRef = (0, _react.useRef)(null);
  const handleClose = (0, _react.useCallback)(() => {
    dispatch(_store.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
  }, [dispatch, timelineId]);

  // pressing the ESC key closes the timeline portal
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.key === _eui.keys.ESCAPE) {
      handleClose();
    }
  }, [handleClose]);
  (0, _use_timeline_save_prompt.useTimelineSavePrompt)(timelineId, onAppLeave);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !show
  }, /*#__PURE__*/_react.default.createElement(_modal.TimelineModal, {
    timelineId: timelineId,
    visible: show,
    openToggleRef: openToggleRef
  })), /*#__PURE__*/_react.default.createElement(_bottom_bar.TimelineBottomBar, {
    show: show,
    timelineId: timelineId,
    openToggleRef: openToggleRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }));
});
TimelineWrapper.displayName = 'TimelineWrapper';