"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryTimelineById = exports.isUntitled = exports.getTimelineTitle = exports.getTimelineStatus = exports.getPinnedEventCount = exports.getNotesCount = exports.formatTimelineResponseToModel = exports.defaultTimelineToTimelineModel = exports.OPEN_TIMELINE_CLASS_NAME = void 0;
var _fp = require("@kbn/safer-lodash-set/fp");
var _fp2 = require("lodash/fp");
var _uuid = require("uuid");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _use_discover_in_timeline_context = require("../../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _timeline = require("../../../../common/types/timeline");
var _timeline2 = require("../../../../common/api/timeline");
var _use_update_timeline = require("./use_update_timeline");
var _defaults = require("../../store/defaults");
var _default_headers = require("../timeline/body/column_headers/default_headers");
var _data_provider = require("../timeline/data_providers/data_provider");
var _normalize_time_range = require("../../../common/utils/normalize_time_range");
var _default_date_settings = require("../../../common/utils/default_date_settings");
var _api = require("../../containers/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_TIMELINE_CLASS_NAME = exports.OPEN_TIMELINE_CLASS_NAME = 'open-timeline';

/** Returns a count of the pinned events in a timeline */
const getPinnedEventCount = ({
  pinnedEventIds
}) => pinnedEventIds != null ? Object.keys(pinnedEventIds).length : 0;

/** Returns the sum of all notes added to pinned events and notes applicable to the timeline */
exports.getPinnedEventCount = getPinnedEventCount;
const getNotesCount = ({
  eventIdToNoteIds,
  noteIds
}) => {
  const eventNoteCount = eventIdToNoteIds != null ? Object.keys(eventIdToNoteIds).reduce((count, eventId) => count + eventIdToNoteIds[eventId].length, 0) : 0;
  const globalNoteCount = noteIds != null ? noteIds.length : 0;
  return eventNoteCount + globalNoteCount;
};

/** Returns true if the timeline is untitlied */
exports.getNotesCount = getNotesCount;
const isUntitled = ({
  title
}) => title == null || title.trim().length === 0;
exports.isUntitled = isUntitled;
const parseString = params => {
  try {
    return JSON.parse(params);
  } catch {
    return params;
  }
};
const setTimelineColumn = (col, defaultHeadersValue) => {
  var _defaultHeadersValue$;
  return Object.entries(col).reduce((acc, [key, value]) => {
    if (key !== 'id' && value != null) {
      return {
        ...acc,
        [key]: value
      };
    }
    return acc;
  }, {
    columnHeaderType: _default_headers.defaultColumnHeaderType,
    id: col.id != null ? col.id : 'unknown',
    initialWidth: (_defaultHeadersValue$ = defaultHeadersValue.find(defaultCol => col.id === defaultCol.id)) === null || _defaultHeadersValue$ === void 0 ? void 0 : _defaultHeadersValue$.initialWidth
  });
};
const setTimelineFilters = filter => ({
  $state: {
    store: 'appState'
  },
  meta: {
    ...filter.meta,
    ...(filter.meta && filter.meta.field != null ? {
      params: parseString(filter.meta.field)
    } : {}),
    ...(filter.meta && filter.meta.params != null ? {
      params: parseString(filter.meta.params)
    } : {}),
    ...(filter.meta && filter.meta.value != null ? {
      value: parseString(filter.meta.value)
    } : {})
  },
  ...(filter.exists != null ? {
    exists: parseString(filter.exists)
  } : {}),
  ...(filter.match_all != null ? {
    exists: parseString(filter.match_all)
  } : {}),
  ...(filter.missing != null ? {
    exists: parseString(filter.missing)
  } : {}),
  ...(filter.query != null ? {
    query: parseString(filter.query)
  } : {}),
  ...(filter.range != null ? {
    range: parseString(filter.range)
  } : {}),
  ...(filter.script != null ? {
    exists: parseString(filter.script)
  } : {})
});
const setEventIdToNoteIds = (duplicate, eventIdToNoteIds) => duplicate ? {} : eventIdToNoteIds != null ? eventIdToNoteIds.reduce((acc, note) => {
  if (note.eventId != null) {
    const eventNotes = (0, _fp2.getOr)([], note.eventId, acc);
    return {
      ...acc,
      [note.eventId]: [...eventNotes, note.noteId]
    };
  }
  return acc;
}, {}) : {};
const setPinnedEventsSaveObject = (duplicate, pinnedEventsSaveObject) => duplicate ? {} : pinnedEventsSaveObject != null ? pinnedEventsSaveObject.reduce((acc, pinnedEvent) => ({
  ...acc,
  ...(pinnedEvent.eventId != null ? {
    [pinnedEvent.eventId]: pinnedEvent
  } : {})
}), {}) : {};
const setPinnedEventIds = (duplicate, pinnedEventIds) => duplicate ? {} : pinnedEventIds != null ? pinnedEventIds.reduce((acc, pinnedEventId) => ({
  ...acc,
  [pinnedEventId]: true
}), {}) : {};
const getTemplateTimelineId = (timeline, duplicate, targetTimelineType) => {
  if (targetTimelineType === _timeline2.TimelineTypeEnum.default && timeline.timelineType === _timeline2.TimelineTypeEnum.template) {
    return timeline.templateTimelineId;
  }
  return duplicate && timeline.timelineType === _timeline2.TimelineTypeEnum.template ?
  // TODO: MOVE TO THE BACKEND
  (0, _uuid.v4)() : timeline.templateTimelineId;
};
const convertToDefaultField = ({
  and,
  ...dataProvider
}) => {
  if (dataProvider.type === _timeline2.DataProviderTypeEnum.template) {
    return (0, _deepmerge.default)(dataProvider, {
      type: _timeline2.DataProviderTypeEnum.default,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      enabled: dataProvider.queryMatch.operator !== _data_provider.IS_OPERATOR,
      queryMatch: {
        value:
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        dataProvider.queryMatch.operator === _data_provider.IS_OPERATOR ? '' : dataProvider.queryMatch.value
      }
    });
  }
  return dataProvider;
};
const getDataProviders = (duplicate, dataProviders, timelineType) => {
  if (duplicate && dataProviders && timelineType === _timeline2.TimelineTypeEnum.default) {
    return dataProviders.map(dataProvider => {
      var _dataProvider$and$map, _dataProvider$and;
      return {
        ...convertToDefaultField(dataProvider),
        and: (_dataProvider$and$map = (_dataProvider$and = dataProvider.and) === null || _dataProvider$and === void 0 ? void 0 : _dataProvider$and.map(convertToDefaultField)) !== null && _dataProvider$and$map !== void 0 ? _dataProvider$and$map : []
      };
    });
  }
  return dataProviders;
};
const getTimelineTitle = (timeline, duplicate, timelineType) => {
  const isCreateTimelineFromAction = timelineType && timeline.timelineType !== timelineType;
  if (isCreateTimelineFromAction) return '';
  return duplicate ? `${timeline.title} - Duplicate` : timeline.title || '';
};
exports.getTimelineTitle = getTimelineTitle;
const getTimelineStatus = (timeline, duplicate, timelineType) => {
  const isCreateTimelineFromAction = timelineType && timeline.timelineType !== timelineType;
  if (isCreateTimelineFromAction) return _timeline2.TimelineStatusEnum.draft;
  return duplicate ? _timeline2.TimelineStatusEnum.active : timeline.status;
};
exports.getTimelineStatus = getTimelineStatus;
const defaultTimelineToTimelineModel = (timeline, duplicate, timelineType) => {
  var _timeline$excludedRow;
  const isTemplate = timeline.timelineType === _timeline2.TimelineTypeEnum.template;
  const defaultHeadersValue = _default_headers.defaultUdtHeaders;
  const timelineEntries = {
    ...timeline,
    columns: timeline.columns != null ? timeline.columns.map(col => setTimelineColumn(col, defaultHeadersValue)) : defaultHeadersValue,
    defaultColumns: defaultHeadersValue,
    dateRange: timeline.status === _timeline2.TimelineStatusEnum.immutable && timeline.timelineType === _timeline2.TimelineTypeEnum.template ? {
      start: _default_date_settings.DEFAULT_FROM_MOMENT.toISOString(),
      end: _default_date_settings.DEFAULT_TO_MOMENT.toISOString()
    } : timeline.dateRange,
    dataProviders: getDataProviders(duplicate, timeline.dataProviders, timelineType),
    excludedRowRendererIds: isTemplate ? [] : (_timeline$excludedRow = timeline.excludedRowRendererIds) !== null && _timeline$excludedRow !== void 0 ? _timeline$excludedRow : _timeline2.RowRendererValues,
    eventIdToNoteIds: setEventIdToNoteIds(duplicate, timeline.eventIdToNoteIds),
    filters: timeline.filters != null ? timeline.filters.map(setTimelineFilters) : [],
    isFavorite: duplicate ? false : timeline.favorite != null ? timeline.favorite.length > 0 : false,
    noteIds: duplicate ? [] : timeline.noteIds != null ? timeline.noteIds : [],
    pinnedEventIds: setPinnedEventIds(duplicate, timeline.pinnedEventIds),
    pinnedEventsSaveObject: setPinnedEventsSaveObject(duplicate, timeline.pinnedEventsSaveObject),
    id: duplicate ? '' : timeline.savedObjectId,
    status: getTimelineStatus(timeline, duplicate, timelineType),
    savedObjectId: duplicate ? null : timeline.savedObjectId,
    version: duplicate ? null : timeline.version,
    timelineType: timelineType !== null && timelineType !== void 0 ? timelineType : timeline.timelineType,
    title: getTimelineTitle(timeline, duplicate, timelineType),
    templateTimelineId: getTemplateTimelineId(timeline, duplicate, timelineType),
    templateTimelineVersion: duplicate && isTemplate ? 1 : timeline.templateTimelineVersion
  };
  return Object.entries(timelineEntries).reduce((acc, [key, value]) => value != null ? (0, _fp.set)(key, value, acc) : acc, {
    ..._defaults.timelineDefaults,
    id: ''
  });
};
exports.defaultTimelineToTimelineModel = defaultTimelineToTimelineModel;
const formatTimelineResponseToModel = (timelineToOpen, duplicate = false, timelineType) => {
  const {
    notes,
    ...timelineModel
  } = timelineToOpen;
  return {
    notes,
    timeline: defaultTimelineToTimelineModel(timelineModel, duplicate, timelineType)
  };
};
exports.formatTimelineResponseToModel = formatTimelineResponseToModel;
const useQueryTimelineById = () => {
  const {
    resetDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const updateTimeline = (0, _use_update_timeline.useUpdateTimeline)();
  return ({
    activeTimelineTab = _timeline.TimelineTabs.query,
    duplicate = false,
    timelineId,
    timelineType,
    onError,
    onOpenTimeline,
    openTimeline = true,
    savedSearchId,
    query
  }) => {
    if (timelineId == null) {
      var _query$expression;
      updateTimeline({
        id: _timeline.TimelineId.active,
        duplicate: false,
        notes: [],
        from: _default_date_settings.DEFAULT_FROM_MOMENT.toISOString(),
        to: _default_date_settings.DEFAULT_TO_MOMENT.toISOString(),
        timeline: {
          ..._defaults.timelineDefaults,
          columns: _default_headers.defaultUdtHeaders,
          id: _timeline.TimelineId.active,
          kqlQuery: {
            filterQuery: {
              kuery: query !== null && query !== void 0 ? query : null,
              serializedQuery: (_query$expression = query === null || query === void 0 ? void 0 : query.expression) !== null && _query$expression !== void 0 ? _query$expression : ''
            }
          },
          activeTab: activeTimelineTab,
          show: openTimeline,
          initialized: true,
          savedSearchId: savedSearchId !== null && savedSearchId !== void 0 ? savedSearchId : null,
          excludedRowRendererIds: timelineType !== _timeline2.TimelineTypeEnum.template ? _defaults.timelineDefaults.excludedRowRendererIds : []
        }
      });
      resetDiscoverAppState();
    } else {
      return Promise.resolve((0, _api.resolveTimeline)(timelineId)).then(result => {
        if (!result) return;
        const {
          timeline,
          notes
        } = formatTimelineResponseToModel(result.timeline, duplicate, timelineType);
        if (onOpenTimeline != null) {
          onOpenTimeline(timeline);
        } else if (updateTimeline) {
          const {
            from,
            to
          } = (0, _normalize_time_range.normalizeTimeRange)({
            from: (0, _fp2.getOr)(null, 'dateRange.start', timeline),
            to: (0, _fp2.getOr)(null, 'dateRange.end', timeline)
          });
          updateTimeline({
            duplicate,
            from,
            id: _timeline.TimelineId.active,
            notes,
            resolveTimelineConfig: {
              outcome: result.outcome,
              alias_target_id: result.alias_target_id,
              alias_purpose: result.alias_purpose
            },
            timeline: {
              ...timeline,
              activeTab: activeTimelineTab,
              show: openTimeline,
              dateRange: {
                start: from,
                end: to
              },
              savedSearchId: timeline.savedSearchId
            },
            to,
            // The query has already been resolved before
            // when the response was mapped to a model.
            // No need to do that again.
            preventSettingQuery: true
          });
          return resetDiscoverAppState(timeline.savedSearchId);
        }
      }).catch(error => {
        if (onError != null) {
          onError(error, timelineId);
        }
      });
    }
  };
};
exports.useQueryTimelineById = useQueryTimelineById;