"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentTimelines = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _header = require("./header");
var _hover_popover = require("../../../common/components/hover_popover");
var _timeline = require("../../../../common/api/timeline");
var _counts = require("./counts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClampText = _styled.default.div`
  /* Clamp text content to 3 lines */
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: break-word;
`;
const RecentTimelinesItem = /*#__PURE__*/_react.default.memo(({
  timeline,
  onOpenTimeline,
  isLastItem
}) => {
  const handleClick = (0, _react.useCallback)(() => onOpenTimeline({
    duplicate: true,
    timelineId: `${timeline.savedObjectId}`
  }), [onOpenTimeline, timeline.savedObjectId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hover_popover.HoverPopover, {
    anchorPosition: "rightDown",
    hoverContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: timeline.timelineType === _timeline.TimelineTypeEnum.default ? i18n.OPEN_AS_DUPLICATE : i18n.OPEN_AS_DUPLICATE_TEMPLATE,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": timeline.timelineType === _timeline.TimelineTypeEnum.default ? i18n.OPEN_AS_DUPLICATE : i18n.OPEN_AS_DUPLICATE_TEMPLATE,
      "data-test-subj": "open-duplicate",
      isDisabled: timeline.savedObjectId == null,
      iconSize: "s",
      iconType: "copy",
      onClick: handleClick,
      size: "s"
    }))
  }, /*#__PURE__*/_react.default.createElement(_header.RecentTimelineHeader, {
    onOpenTimeline: onOpenTimeline,
    timeline: timeline
  }), /*#__PURE__*/_react.default.createElement(_counts.RecentTimelineCounts, {
    timeline: timeline
  }), timeline.description && timeline.description.length && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(ClampText, null, timeline.description))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })));
});
RecentTimelinesItem.displayName = 'RecentTimelinesItem';
const RecentTimelines = exports.RecentTimelines = /*#__PURE__*/_react.default.memo(({
  noTimelinesMessage,
  onOpenTimeline,
  timelines
}) => {
  const content = (0, _react.useMemo)(() => timelines.map((timeline, index) => /*#__PURE__*/_react.default.createElement(RecentTimelinesItem, {
    key: `${timeline.savedObjectId}-${timeline.title}`,
    timeline: timeline,
    onOpenTimeline: onOpenTimeline,
    isLastItem: index === timelines.length - 1
  })), [onOpenTimeline, timelines]);
  if (timelines.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, noTimelinesMessage));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "overview-recent-timelines"
  }, content);
});
RecentTimelines.displayName = 'RecentTimelines';