"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.policyListApiPathHandlers = exports.mockPolicyResultList = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _ingest = require("../../../services/policies/ingest");
var _generate_data = require("../../../../../common/endpoint/generate_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generator = new _generate_data.EndpointDocGenerator('policy-list');

/**
 * Returns the response body for a call to get the list of Policies
 * @param options
 */
const mockPolicyResultList = (options = {}) => {
  const {
    total = 1,
    request_page_size: requestPageSize = 10,
    request_page_index: requestPageIndex = 0
  } = options;

  // Skip any that are before the page we're on
  const numberToSkip = requestPageSize * requestPageIndex;

  // total - numberToSkip is the count of non-skipped ones, but return no more than a pageSize, and no less than 0
  const actualCountToReturn = Math.max(Math.min(total - numberToSkip, requestPageSize), 0);
  const policies = [];
  for (let index = 0; index < actualCountToReturn; index++) {
    policies.push(generator.generatePolicyPackagePolicy());
  }
  const mock = {
    items: policies,
    total,
    page: requestPageIndex,
    perPage: requestPageSize
  };
  return mock;
};

/**
 * Returns an object comprised of the API path as the key along with a function that
 * returns that API's result value
 */
exports.mockPolicyResultList = mockPolicyResultList;
const policyListApiPathHandlers = (totalPolicies = 1) => {
  return {
    [_ingest.INGEST_API_PACKAGE_POLICIES]: () => {
      return mockPolicyResultList({
        total: totalPolicies
      });
    },
    [_ingest.INGEST_API_EPM_PACKAGES]: () => {
      return {
        items: [generator.generateEpmPackage()]
      };
    },
    [_common.epmRouteService.getInfoPath('endpoint')]: () => {
      return {
        item: generator.generateEpmPackageInfo()
      };
    }
  };
};
exports.policyListApiPathHandlers = policyListApiPathHandlers;