"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchLatestScan = void 0;
var _reactQuery = require("@tanstack/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _translations = require("../../translations");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchLatestScan = ({
  isPolling,
  endpointId,
  onSuccess,
  onInsightGenerationFailure
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)([`fetchOngoingTasks-${endpointId}`], async () => {
    try {
      const response = await http.get(_elasticAssistantCommon.DEFEND_INSIGHTS, {
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
        query: {
          endpoint_ids: [endpointId],
          size: 1
        }
      });
      const defendInsight = response.data[0];
      if (!defendInsight) {
        // no previous scan record - treat as 0 expected insights
        onSuccess(0);
        return undefined;
      }
      const status = defendInsight.status;
      if (status === _elasticAssistantCommon.DefendInsightStatusEnum.failed) {
        toasts.addDanger({
          title: _translations.WORKFLOW_INSIGHTS.toasts.fetchPendingInsightsError,
          text: defendInsight.failureReason
        });
        onInsightGenerationFailure();
      }
      if (status === _elasticAssistantCommon.DefendInsightStatusEnum.succeeded) {
        const expectedCount = defendInsight.insights.reduce((acc, insight) => {
          if (!insight.events) {
            return acc;
          }
          return acc + insight.events.length;
        }, 0);
        onSuccess(expectedCount);
      }
      return defendInsight;
    } catch (error) {
      var _error$body;
      toasts.addDanger({
        title: _translations.WORKFLOW_INSIGHTS.toasts.fetchPendingInsightsError,
        text: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error
      });
      return undefined;
    }
  }, {
    refetchOnWindowFocus: false,
    refetchInterval: isPolling ? 2000 : false
  });
};
exports.useFetchLatestScan = useFetchLatestScan;