"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataTestSubj = void 0;
var _console_state = require("../../components/console_state/console_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the `data-test-subj` that was defined when the `Console` was rendered.
 * Can optionally set a suffix on that value if one is provided
 */
const useDataTestSubj = (suffix = '') => {
  const dataTestSubj = (0, _console_state.useConsoleStore)().state.dataTestSubj;
  if (!dataTestSubj) {
    return '';
  }
  return dataTestSubj + (suffix ? `-${suffix}` : '');
};
exports.useDataTestSubj = useDataTestSubj;