"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsMisconfigurationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _i18n = require("@kbn/i18n");
var _flyout_navigation = require("../../../shared/components/flyout_navigation");
var _flyout_header = require("../../../shared/components/flyout_header");
var _kibana = require("../../../../common/lib/kibana");
var _formatted_date = require("../../../../common/components/formatted_date");
var _flyout_title = require("../../../shared/components/flyout_title");
var _flyout_body = require("../../../shared/components/flyout_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsMisconfigurationPanel = ({
  resourceId,
  ruleId,
  isPreviewMode
}) => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CspFlyout = cloudSecurityPosture.getCloudSecurityPostureMisconfigurationFlyout();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    isPreviewMode: isPreviewMode
  }), /*#__PURE__*/_react.default.createElement(CspFlyout.Component, {
    ruleId: ruleId,
    resourceId: resourceId
  }, ({
    finding,
    createRuleFn
  }) => {
    var _finding$result;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false,
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CspEvaluationBadge, {
      type: finding === null || finding === void 0 ? void 0 : (_finding$result = finding.result) === null || _finding$result === void 0 ? void 0 : _finding$result.evaluation
    })), finding['@timestamp'] && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.securitySolution.csp.findingsFlyout.evaluatedAt', {
      defaultMessage: 'Evaluated at '
    })), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(finding['@timestamp'])
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
      title: finding.rule.name
    }))), /*#__PURE__*/_react.default.createElement(CspFlyout.Header, {
      finding: finding
    })), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, /*#__PURE__*/_react.default.createElement(CspFlyout.Body, {
      finding: finding
    })), !isPreviewMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(CspFlyout.Footer, {
      createRuleFn: createRuleFn
    })));
  }));
};
exports.FindingsMisconfigurationPanel = FindingsMisconfigurationPanel;
FindingsMisconfigurationPanel.displayName = 'FindingsMisconfigurationPanel';