"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlertSummary = void 0;
var _reactQuery = require("@tanstack/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _elasticAssistant = require("@kbn/elastic-assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * API call for fetching alert_summary for current spaceId
 *
 * @param {Object} options - The options object.
 * @param {string} options.alertId - alert id
 * @param {AbortSignal} [options.signal] - AbortSignal
 *
 * @returns {useQuery} hook for getting the status of the alert_summary
 */

const useFetchAlertSummary = ({
  alertId,
  connectorId,
  signal
}) => {
  const {
    assistantAvailability: {
      isAssistantEnabled
    },
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const QUERY = {
    page: 1,
    per_page: 1,
    // only fetching one alert summary
    filter: `alert_id:${alertId}`,
    connector_id: connectorId
  };
  const CACHING_KEYS = [_elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND, QUERY.page, QUERY.per_page, QUERY.filter, QUERY.connector_id, _elasticAssistantCommon.API_VERSIONS.internal.v1];
  return (0, _reactQuery.useQuery)(CACHING_KEYS, async () => http.fetch(_elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND, {
    method: 'GET',
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    query: QUERY,
    signal
  }), {
    initialData: {
      data: [],
      page: 1,
      perPage: 1,
      total: 0,
      prompt: ''
    },
    placeholderData: {
      data: [],
      page: 1,
      perPage: 1,
      total: 0,
      prompt: ''
    },
    keepPreviousData: true,
    enabled: isAssistantEnabled
  });
};
exports.useFetchAlertSummary = useFetchAlertSummary;