"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchMonitoredIndices = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../../api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchMonitoredIndices = () => {
  const {
    listPrivMonMonitoredIndices
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(['POST', 'LIST_PRIVILEGED_USER_MONITORED_INDICES'], ({
    signal
  }) => listPrivMonMonitoredIndices({
    signal
  }), {
    keepPreviousData: true,
    refetchOnWindowFocus: false
  });
};
exports.useFetchMonitoredIndices = useFetchMonitoredIndices;