"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToTime = exports.getFromTime = exports.getBucketTimeRange = exports.generateVisualizationESQLQuery = exports.generateListESQLQuery = exports.generateESQLSource = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getToTime = () => _constants.CURRENT_TIME.clone().set({
  minute: 0,
  second: 0,
  millisecond: 0
}); // Start of the current hour
exports.getToTime = getToTime;
const getFromTime = () => getToTime().subtract(1, 'day'); // 24 hours ago
exports.getFromTime = getFromTime;
const getBucketTimeRange = () => ({
  from: getFromTime().toISOString(),
  to: getToTime().subtract(1, 'hour').toISOString() // We shouldn't include the current hour. Since it is the top boundary, no dates will be in this bucket.
});
exports.getBucketTimeRange = getBucketTimeRange;
const generateRandomDate = (from, to) => {
  // Generate a date between the two given moment js dates
  const randomDate = from.clone().add(Math.random() * (to.valueOf() - from.valueOf()), 'milliseconds');
  return randomDate.toISOString();
};
const generateUserRowData = ({
  quantity,
  user,
  target,
  right,
  ip
}) => {
  const userRowData = [];
  for (let i = 0; i < quantity; i++) {
    userRowData.push(`"${user},${target},${right},${ip},${generateRandomDate(getFromTime(), getToTime())}"`);
  }
  return userRowData.join(',');
};
const generateESQLSource = () => {
  const rows = _constants.GRANTED_RIGHTS_DATA.map(row => generateUserRowData(row)).join(',');
  return `ROW data=[${rows}]
            | MV_EXPAND data
            | EVAL row = SPLIT(data, ",")
            | EVAL privileged_user = MV_SLICE(row, 0), target_user = MV_SLICE(row, 1), right = MV_SLICE(row, 2), ip = MV_SLICE(row, 3), @timestamp = TO_DATETIME(MV_SLICE(row, 4))
            | DROP row`;
};
exports.generateESQLSource = generateESQLSource;
const generateListESQLQuery = esqlSource => (sortField, sortDirection, currentPage) => `${esqlSource}
        | SORT ${String(sortField)} ${sortDirection}
        | LIMIT ${1 + currentPage * _constants.PAGE_SIZE}`; // Load one extra item for the pagination
exports.generateListESQLQuery = generateListESQLQuery;
const generateVisualizationESQLQuery = esqlSource => (stackByField, timerange) => `${esqlSource}
    | STATS results = COUNT(*) by timestamp = BUCKET(@timestamp, 30, "${timerange.from}", "${timerange.to}"), ${stackByField}`;
exports.generateVisualizationESQLQuery = generateVisualizationESQLQuery;