"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_global_time = require("../../../../../../common/containers/use_global_time");
var _pad_chart_severity_filter = require("./pad_chart_severity_filter");
var _pad_query_hooks = require("./hooks/pad_query_hooks");
var _pad_anomaly_bands = require("./pad_anomaly_bands");
var _pad_user_name_list = require("./pad_user_name_list");
var _pad_heatmap = require("./pad_heatmap");
var _manage_query = require("../../../../../../common/components/page/manage_query");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedAccessDetectionChart = ({
  jobIds,
  spaceId
}) => {
  var _data$userNames, _data$anomalyRecords, _data$userNames2;
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    bands,
    toggleHiddenBand
  } = (0, _pad_anomaly_bands.useAnomalyBands)();
  const {
    data,
    isLoading,
    isError,
    inspect,
    refetch
  } = (0, _pad_query_hooks.usePrivilegedAccessDetectionAnomaliesQuery)({
    jobIds,
    anomalyBands: bands,
    spaceId
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _.PRIVILEGED_ACCESS_DETECTIONS_QUERY_ID,
    loading: isLoading
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_pad_chart_severity_filter.PrivilegedAccessDetectionSeverityFilter, {
    anomalyBands: bands,
    toggleHiddenBand: toggleHiddenBand
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_pad_user_name_list.UserNameList, {
    userNames: (_data$userNames = data === null || data === void 0 ? void 0 : data.userNames) !== null && _data$userNames !== void 0 ? _data$userNames : []
  }), /*#__PURE__*/_react.default.createElement(_pad_heatmap.PrivilegedAccessDetectionHeatmap, {
    anomalyBands: bands,
    records: (_data$anomalyRecords = data === null || data === void 0 ? void 0 : data.anomalyRecords) !== null && _data$anomalyRecords !== void 0 ? _data$anomalyRecords : [],
    userNames: (_data$userNames2 = data === null || data === void 0 ? void 0 : data.userNames) !== null && _data$userNames2 !== void 0 ? _data$userNames2 : [],
    isLoading: isLoading,
    isError: isError
  })));
};
exports.PrivilegedAccessDetectionChart = PrivilegedAccessDetectionChart;