"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivilegedAccessDetectionAnomaliesQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _esqlUtils = require("@kbn/esql-utils");
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _constants = require("../../../../../../../../common/constants");
var _use_esql_global_filter = require("../../../../../../../common/hooks/esql/use_esql_global_filter");
var _esql = require("../../../../../../../common/utils/esql");
var _kibana = require("../../../../../../../common/lib/kibana");
var _use_error_toast = require("../../../../../../../common/hooks/use_error_toast");
var _pad_esql_source_query_hooks = require("./pad_esql_source_query_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * An Anomaly record that ensures consistent timestamps as milliseconds since Epoch time.
 */

const usePrivilegedAccessDetectionTopUsersQuery = params => {
  const search = (0, _kibana.useKibana)().services.data.search.search;
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const padTopAnomalousUsersEsqlSource = (0, _pad_esql_source_query_hooks.usePadTopAnomalousUsersEsqlSource)({
    ...params,
    usersLimit: 10
  });
  const {
    isLoading,
    data,
    isError
  } = (0, _reactQuery.useQuery)([filterQuery, padTopAnomalousUsersEsqlSource], async ({
    signal
  }) => {
    var _await$getESQLResults;
    return (0, _esql.esqlResponseToRecords)((_await$getESQLResults = await (0, _esqlUtils.getESQLResults)({
      esqlQuery: padTopAnomalousUsersEsqlSource,
      search,
      signal,
      filter: filterQuery
    })) === null || _await$getESQLResults === void 0 ? void 0 : _await$getESQLResults.response);
  });
  return {
    isLoading,
    userNames: data === null || data === void 0 ? void 0 : data.map(each => each['user.name']),
    isError
  };
};
const usePrivilegedAccessDetectionAnomaliesQuery = params => {
  const search = (0, _kibana.useKibana)().services.data.search.search;
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const {
    userNames,
    isError: isTopUsersError,
    isLoading: isTopUsersLoading
  } = usePrivilegedAccessDetectionTopUsersQuery(params);
  const padAnomalyDataEsqlSource = (0, _pad_esql_source_query_hooks.usePadAnomalyDataEsqlSource)({
    ...params,
    userNames
  });
  const {
    isLoading: isAnomaliesLoading,
    data,
    error,
    isError: isAnomaliesError,
    refetch
  } = (0, _reactQuery.useQuery)([filterQuery, padAnomalyDataEsqlSource, userNames], async ({
    signal
  }) => {
    if (!padAnomalyDataEsqlSource || !userNames || userNames.length === 0) {
      return {
        anomalyRecords: [],
        userNames: []
      };
    }
    const anomalyRecords = (0, _esql.esqlResponseToRecords)((await (0, _esqlUtils.getESQLResults)({
      esqlQuery: padAnomalyDataEsqlSource,
      // here
      search,
      signal,
      filter: filterQuery
    })).response).map(eachRawRecord => ({
      ...eachRawRecord,
      '@timestamp': new Date(eachRawRecord['@timestamp']).getTime()
    }));
    return {
      anomalyRecords: anomalyRecords !== null && anomalyRecords !== void 0 ? anomalyRecords : [],
      userNames: userNames !== null && userNames !== void 0 ? userNames : []
    };
  }, {
    enabled: !!padAnomalyDataEsqlSource && !!userNames,
    keepPreviousData: true
  });
  const inspect = (0, _react.useMemo)(() => {
    return {
      dsl: [JSON.stringify({
        index: [_constants.ML_ANOMALIES_INDEX],
        body: (0, _esqlUtils.prettifyQuery)(padAnomalyDataEsqlSource !== null && padAnomalyDataEsqlSource !== void 0 ? padAnomalyDataEsqlSource : '', false)
      }, null, 2)],
      response: data ? [JSON.stringify(data, null, 2)] : []
    };
  }, [data, padAnomalyDataEsqlSource]);
  (0, _use_error_toast.useErrorToast)(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.queryError', {
    defaultMessage: 'There was an error loading privileged access detection data'
  }), error);
  return {
    data,
    isLoading: isTopUsersLoading || isAnomaliesLoading,
    isError: isTopUsersError || isAnomaliesError,
    refetch,
    error,
    inspect
  };
};
exports.usePrivilegedAccessDetectionAnomaliesQuery = usePrivilegedAccessDetectionAnomaliesQuery;