"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskInputTab = exports.getInsightsInputTab = exports.getFieldsTableTab = exports.RISK_INPUTS_TAB_TEST_ID = exports.INSIGHTS_TAB_TEST_ID = exports.FIELDS_TABLE_TAB_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fields_table_tab = require("../../../cloud_security_posture/components/csp_details/fields_table_tab");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _test_ids = require("../../../flyout/shared/test_ids");
var _risk_inputs_tab = require("./tabs/risk_inputs/risk_inputs_tab");
var _insights_tab_csp = require("../../../cloud_security_posture/components/csp_details/insights_tab_csp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_INPUTS_TAB_TEST_ID = exports.RISK_INPUTS_TAB_TEST_ID = `${_test_ids.PREFIX}RiskInputsTab`;
const INSIGHTS_TAB_TEST_ID = exports.INSIGHTS_TAB_TEST_ID = `${_test_ids.PREFIX}InsightInputsTab`;
const FIELDS_TABLE_TAB_TEST_ID = exports.FIELDS_TABLE_TAB_TEST_ID = `${_test_ids.PREFIX}FieldsTableTab`;
const getRiskInputTab = ({
  entityType,
  entityName,
  scopeId
}) => ({
  id: _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS,
  'data-test-subj': RISK_INPUTS_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.userDetails.riskInputs.tabLabel",
    defaultMessage: "Risk contributions"
  }),
  content: /*#__PURE__*/_react.default.createElement(_risk_inputs_tab.RiskInputsTab, {
    entityType: entityType,
    entityName: entityName,
    scopeId: scopeId
  })
});
exports.getRiskInputTab = getRiskInputTab;
const getInsightsInputTab = ({
  name,
  fieldName,
  scopeId
}) => {
  return {
    id: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
    'data-test-subj': INSIGHTS_TAB_TEST_ID,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.insightsDetails.insights.tabLabel",
      defaultMessage: "Insights"
    }),
    content: /*#__PURE__*/_react.default.createElement(_insights_tab_csp.InsightsTabCsp, {
      value: name,
      field: fieldName,
      scopeId: scopeId
    })
  };
};
exports.getInsightsInputTab = getInsightsInputTab;
const getFieldsTableTab = ({
  document,
  tableStorageKey
}) => {
  return {
    id: _left_panel_header.EntityDetailsLeftPanelTab.FIELDS_TABLE,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.fieldsTableTab.tabLabel",
      defaultMessage: "Fields"
    }),
    content: /*#__PURE__*/_react.default.createElement(_fields_table_tab.FieldsTableTab, {
      document: document,
      tableStorageKey: tableStorageKey
    }),
    'data-test-subj': FIELDS_TABLE_TAB_TEST_ID
  };
};
exports.getFieldsTableTab = getFieldsTableTab;