"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _osquery_flyout_footer = require("./osquery_flyout_footer");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryActionWrapper = _styledComponents.default.div`
  padding: 8px;
`;
// Make sure we keep this and ACTIONS_QUERY_KEY in use_all_live_queries.ts in sync.
const ACTIONS_QUERY_KEY = 'actions';
const OsqueryFlyoutComponent = ({
  agentId,
  defaultValues,
  onClose,
  ecsData
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 3}`
  }), [euiTheme.levels.flyout]);
  const {
    services: {
      osquery
    }
  } = (0, _kibana.useKibana)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const invalidateQueries = (0, _react.useCallback)(() => {
    var _defaultValues$alertI;
    queryClient.invalidateQueries({
      queryKey: [ACTIONS_QUERY_KEY, {
        alertId: defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$alertI = defaultValues.alertIds) === null || _defaultValues$alertI === void 0 ? void 0 : _defaultValues$alertI[0]
      }]
    });
  }, [defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.alertIds, queryClient]);
  const osqueryFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'osqueryFlyoutTitle'
  });
  if (osquery !== null && osquery !== void 0 && osquery.OsqueryAction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      size: "m",
      onClose: onClose,
      "aria-labelledby": osqueryFlyoutTitleId
      // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
      ,
      maskProps: maskProps
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      "data-test-subj": "flyout-header-osquery"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
      id: osqueryFlyoutTitleId
    }, _translations.ACTION_OSQUERY))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(OsqueryActionWrapper, {
      "data-test-subj": "flyout-body-osquery"
    }, /*#__PURE__*/_react.default.createElement(osquery.OsqueryAction, {
      agentId: agentId,
      formType: "steps",
      defaultValues: defaultValues,
      ecsData: ecsData,
      onSuccess: invalidateQueries
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_osquery_flyout_footer.OsqueryEventDetailsFooter, {
      handleClick: onClose,
      "data-test-subj": "flyout-footer-osquery"
    })));
  }
  return null;
};
const OsqueryFlyout = exports.OsqueryFlyout = /*#__PURE__*/_react.default.memo(OsqueryFlyoutComponent);