"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTotalRuleCount = exports.getNumOfCoveredTechniques = void 0;
var _detection_engine = require("../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTotalRuleCount = (technique, activity) => {
  if (!activity) {
    return technique.enabledRules.length + technique.disabledRules.length;
  }
  let totalRuleCount = 0;
  if (activity.includes(_detection_engine.CoverageOverviewRuleActivity.Enabled)) {
    totalRuleCount += technique.enabledRules.length;
  }
  if (activity.includes(_detection_engine.CoverageOverviewRuleActivity.Disabled)) {
    totalRuleCount += technique.disabledRules.length;
  }
  return totalRuleCount;
};
exports.getTotalRuleCount = getTotalRuleCount;
const getNumOfCoveredTechniques = tactic => tactic.techniques.filter(technique => technique.enabledRules.length !== 0).length;
exports.getNumOfCoveredTechniques = getNumOfCoveredTechniques;