"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindRules = void 0;
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_find_rules_query = require("../api/hooks/use_find_rules_query");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal, and error handler.
 *
 * @param requestArgs - fetch rules filters/pagination
 * @param options - react-query options
 * @returns useQuery result
 */
const useFindRules = (requestArgs, options) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_find_rules_query.useFindRulesQuery)(requestArgs, {
    onError: error => addError(error, {
      title: i18n.RULE_AND_TIMELINE_FETCH_FAILURE
    }),
    ...options
  });
};
exports.useFindRules = useFindRules;