"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewSpec = void 0;
var _react = require("react");
var _constants = require("../constants");
var _use_data_view = require("./use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an object with the dataViewSpec and status values for the given scopeName.
 * IMPORTANT: If fields are not required, make sure to pass `includeFields = false`.
 */
const useDataViewSpec = (scopeName = _constants.DataViewManagerScopeName.default, includeFields = true) => {
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(scopeName);
  return (0, _react.useMemo)(() => {
    var _dataView$toSpec;
    // NOTE: remove this after we are ready for undefined (lazy) data view everywhere in the app
    // https://github.com/elastic/security-team/issues/11959
    if (!dataView) {
      return {
        dataViewSpec: {
          id: '',
          title: ''
        },
        status
      };
    }
    return {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : (_dataView$toSpec = dataView.toSpec) === null || _dataView$toSpec === void 0 ? void 0 : _dataView$toSpec.call(dataView, includeFields),
      status
    };
  }, [dataView, includeFields, status]);
};
exports.useDataViewSpec = useDataViewSpec;