"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStoredIntegrationTabId = exports.useStoredIntegrationSearchTerm = exports.useDefinedLocalStorage = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocalStorageKey = {
  selectedIntegrationTabId: 'securitySolution.onboarding.selectedIntegrationTabId',
  integrationSearchTerm: 'securitySolution.onboarding.integrationSearchTerm'
};

/**
 * Wrapper hook for useLocalStorage, but always returns the default value when not defined instead of `undefined`.
 */
const useDefinedLocalStorage = (key, defaultValue) => {
  const [value, setValue] = (0, _useLocalStorage.default)(key, defaultValue);
  return [value !== null && value !== void 0 ? value : defaultValue, setValue];
};

/**
 * Stores the selected integration tab ID per space
 */
exports.useDefinedLocalStorage = useDefinedLocalStorage;
const useStoredIntegrationTabId = (spaceId, defaultSelectedTabId) => useDefinedLocalStorage(`${LocalStorageKey.selectedIntegrationTabId}.${spaceId}`, defaultSelectedTabId);

/**
 * Stores the integration search term per space
 */
exports.useStoredIntegrationTabId = useStoredIntegrationTabId;
const useStoredIntegrationSearchTerm = spaceId => useDefinedLocalStorage(`${LocalStorageKey.integrationSearchTerm}.${spaceId}`, null);
exports.useStoredIntegrationSearchTerm = useStoredIntegrationSearchTerm;