"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationCardList = void 0;
var _react = require("react");
var _kibana = require("../../kibana");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../constants");
var _integration_context = require("./integration_context");
var _use_integration_link_state = require("../../../hooks/integrations/use_integration_link_state");
var _integrations = require("../../../utils/integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddSecurityProps = activeIntegrations => {
  const {
    navigateTo,
    getAppUrl
  } = (0, _kibana.useNavigation)();
  const {
    telemetry
  } = (0, _integration_context.useIntegrationContext)();
  return (0, _react.useCallback)(card => {
    const integrationRootUrl = getAppUrl({
      appId: _constants2.INTEGRATION_APP_ID
    });
    const state = (0, _use_integration_link_state.getIntegrationLinkState)(_constants.ONBOARDING_PATH, getAppUrl);
    const url = card.url.includes(_constants.APP_INTEGRATIONS_PATH) ? (0, _integrations.addPathParamToUrl)(card.url, _constants.ONBOARDING_PATH) : card.url;
    const isActive = activeIntegrations.some(integration => integration.name === card.name);
    return {
      ...card,
      titleLineClamp: _constants2.CARD_TITLE_LINE_CLAMP,
      descriptionLineClamp: _constants2.CARD_DESCRIPTION_LINE_CLAMP,
      maxCardHeight: _constants2.MAX_CARD_HEIGHT_IN_PX,
      showInstallationStatus: true,
      url,
      hasDataStreams: isActive,
      onCardClick: () => {
        var _telemetry$reportLink;
        const trackId = `${_constants2.TELEMETRY_INTEGRATION_CARD}_${card.id}`;
        (_telemetry$reportLink = telemetry.reportLinkClick) === null || _telemetry$reportLink === void 0 ? void 0 : _telemetry$reportLink.call(telemetry, trackId);
        if (url.startsWith(_constants.APP_INTEGRATIONS_PATH)) {
          navigateTo({
            appId: _constants2.INTEGRATION_APP_ID,
            path: url.slice(integrationRootUrl.length),
            state
          });
        } else if (url.startsWith('http') || url.startsWith('https')) {
          window.open(url, '_blank');
        } else {
          navigateTo({
            url,
            state
          });
        }
      }
    };
  }, [activeIntegrations, navigateTo, getAppUrl, telemetry]);
};
const useIntegrationCardList = ({
  integrationsList,
  activeIntegrations,
  selectedTab
}) => {
  const featuredCardIds = selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.featuredCardIds;
  const addSecurityProps = useAddSecurityProps(activeIntegrations);
  const integrationCards = (0, _react.useMemo)(() => integrationsList.map(card => addSecurityProps(card)), [integrationsList, addSecurityProps]);
  if (featuredCardIds && featuredCardIds.length > 0) {
    return integrationCards.filter(card => featuredCardIds.includes(card.id));
  }
  return integrationCards !== null && integrationCards !== void 0 ? integrationCards : [];
};
exports.useIntegrationCardList = useIntegrationCardList;