"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIntegrationContext = exports.IntegrationContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationContext = /*#__PURE__*/(0, _react.createContext)(null);
const IntegrationContextProvider = exports.IntegrationContextProvider = /*#__PURE__*/_react.default.memo(({
  children,
  integrationTabs,
  spaceId,
  reportLinkClick
}) => {
  const value = (0, _react.useMemo)(() => ({
    spaceId,
    integrationTabs,
    telemetry: {
      reportLinkClick
    }
  }), [spaceId, integrationTabs, reportLinkClick]);
  return /*#__PURE__*/_react.default.createElement(IntegrationContext.Provider, {
    value: value
  }, children);
});
IntegrationContextProvider.displayName = 'IntegrationContextProvider';
const useIntegrationContext = () => {
  const context = (0, _react.useContext)(IntegrationContext);
  if (!context) {
    throw new Error('No IntegrationContext found. Please wrap the application with IntegrationContextProvider');
  }
  return context;
};
exports.useIntegrationContext = useIntegrationContext;