"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetInventoryStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_asset_inventory_routes = require("./use_asset_inventory_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_INVENTORY_STATUS_KEY = ['GET', 'ASSET_INVENTORY_STATUS'];
const useAssetInventoryStatus = () => {
  const {
    getAssetInventoryStatus
  } = (0, _use_asset_inventory_routes.useAssetInventoryRoutes)();
  return (0, _reactQuery.useQuery)({
    queryKey: ASSET_INVENTORY_STATUS_KEY,
    queryFn: () => getAssetInventoryStatus(),
    refetchInterval: data => {
      if ((data === null || data === void 0 ? void 0 : data.status) === 'ready') {
        return false;
      }
      return 3000;
    },
    refetchOnMount: true
  });
};
exports.useAssetInventoryStatus = useAssetInventoryStatus;