"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnsureDefaultNamespace = void 0;
var _react = require("react");
var _utils = require("./utils");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEnsureDefaultNamespace = ({
  newPolicy,
  input,
  updatePolicy
}) => {
  (0, _react.useEffect)(() => {
    if (newPolicy.namespace === _constants.ASSET_NAMESPACE) return;
    const policy = {
      ...(0, _utils.getAssetPolicy)(newPolicy, input.type),
      namespace: _constants.ASSET_NAMESPACE
    };
    updatePolicy(policy);
  }, [newPolicy, input, updatePolicy]);
};
exports.useEnsureDefaultNamespace = useEnsureDefaultNamespace;