"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_group = require("@kbn/alerts-ui-shared/src/alert_filter_controls/filter_group");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _data_view_context = require("../../hooks/data_view_context");
var _constants = require("../../constants");
var _asset_inventory_filters_loading = require("./asset_inventory_filters_loading");
var _asset_inventory_rule_type_ids = require("./asset_inventory_rule_type_ids");
var _add_empty_data_filter = require("../../utils/add_empty_data_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ASSET_INVENTORY_FILTERS = [{
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.type', {
    defaultMessage: 'Type'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_TYPE
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.name', {
    defaultMessage: 'Name'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_NAME
}, {
  title: _i18n.i18n.translate('xpack.securitySolution.assetInventory.filters.id', {
    defaultMessage: 'ID'
  }),
  fieldName: _constants.ASSET_FIELDS.ENTITY_ID
}];
const AssetInventoryFilters = ({
  setQuery,
  query
}) => {
  const {
    dataView,
    dataViewIsLoading
  } = (0, _data_view_context.useDataViewContext)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  if (!spaceId || !(dataView !== null && dataView !== void 0 && dataView.id)) {
    // TODO Add error handling if no spaceId is found
    return null;
  }
  if (dataViewIsLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_asset_inventory_filters_loading.FilterGroupLoading, null));
  }
  const filters = (0, _add_empty_data_filter.addEmptyDataFilter)(query.filters, dataView.id);
  return /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    dataViewId: dataView.id,
    onFiltersChange: pageFilters => {
      setQuery({
        pageFilters
      });
    },
    ruleTypeIds: _asset_inventory_rule_type_ids.ASSET_INVENTORY_RULE_TYPE_IDS,
    Storage: _public.Storage,
    defaultControls: DEFAULT_ASSET_INVENTORY_FILTERS,
    chainingSystem: "HIERARCHICAL",
    spaceId: spaceId,
    ControlGroupRenderer: _public2.ControlGroupRenderer,
    maxControls: 4,
    query: query.query,
    filters: filters
  });
};
exports.AssetInventoryFilters = AssetInventoryFilters;