"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScoreBaseIndexName = exports.latestRiskScoreIndexPattern = exports.getRiskScoreTimeSeriesIndex = exports.getRiskScoreLatestIndex = exports.allRiskScoreIndexPattern = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskScoreBaseIndexName = exports.riskScoreBaseIndexName = 'risk-score';
const allRiskScoreIndexPattern = exports.allRiskScoreIndexPattern = '.ds-risk-score*';
const latestRiskScoreIndexPattern = exports.latestRiskScoreIndexPattern = 'risk-score.risk-score-latest-*';
const getRiskScoreLatestIndex = (spaceId = 'default') => `${riskScoreBaseIndexName}.risk-score-latest-${spaceId}`;
exports.getRiskScoreLatestIndex = getRiskScoreLatestIndex;
const getRiskScoreTimeSeriesIndex = (spaceId = 'default') => `${riskScoreBaseIndexName}.risk-score-${spaceId}`;
exports.getRiskScoreTimeSeriesIndex = getRiskScoreTimeSeriesIndex;