"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySubFeaturesMap = exports.getSecurityBaseKibanaSubFeatureIds = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointListSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint List access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList', {
    defaultMessage: 'Endpoint List'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.description', {
    defaultMessage: 'Displays all hosts running Elastic Defend and their relevant integration details.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['endpoint_list_all']
      }],
      api: [`${_constants.APP_ID}-writeEndpointList`, `${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeEndpointList', 'readEndpointList']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['endpoint_list_read']
      }],
      api: [`${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEndpointList']
    }]
  }]
});
const trustedApplicationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Applications access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications', {
    defaultMessage: 'Trusted Applications'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.description', {
    defaultMessage: 'Helps mitigate conflicts with other software, usually other antivirus or endpoint security applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['trusted_applications_all',
        // Writing global (not per-policy) Artifacts is gated with Global Artifact Management:ALL starting with siemV3.
        // Users who have been able to write ANY Artifact before are now granted with this privilege to keep existing behavior.
        'global_artifact_management_all']
      }],
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeTrustedApplications`, `${_constants.APP_ID}-readTrustedApplications`, `${_constants.APP_ID}-writeGlobalArtifacts`],
      id: 'trusted_applications_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedApplications', 'readTrustedApplications']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['trusted_applications_read']
      }],
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedApplications']
    }]
  }]
});
const hostIsolationExceptionsBasicSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions', {
    defaultMessage: 'Host Isolation Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.description', {
    defaultMessage: 'Add specific IP addresses that isolated hosts are still allowed to communicate with, even when isolated from the rest of the network.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['host_isolation_exceptions_all',
        // Writing global (not per-policy) Artifacts is gated with Global Artifact Management:ALL starting with siemV3.
        // Users who have been able to write ANY Artifact before are now granted with this privilege to keep existing behavior.
        'global_artifact_management_all']
      }],
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-deleteHostIsolationExceptions`, `${_constants.APP_ID}-readHostIsolationExceptions`, `${_constants.APP_ID}-writeGlobalArtifacts`],
      id: 'host_isolation_exceptions_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['readHostIsolationExceptions', 'deleteHostIsolationExceptions']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['host_isolation_exceptions_read']
      }],
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readHostIsolationExceptions']
    }]
  }]
});
const blocklistSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Blocklist access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList', {
    defaultMessage: 'Blocklist'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.description', {
    defaultMessage: 'Extend Elastic Defend’s protection against malicious processes and protect against potentially harmful applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['blocklist_all',
        // Writing global (not per-policy) Artifacts is gated with Global Artifact Management:ALL starting with siemV3.
        // Users who have been able to write ANY Artifact before are now granted with this privilege to keep existing behavior.
        'global_artifact_management_all']
      }],
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeBlocklist`, `${_constants.APP_ID}-readBlocklist`, `${_constants.APP_ID}-writeGlobalArtifacts`],
      id: 'blocklist_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeBlocklist', 'readBlocklist']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['blocklist_read']
      }],
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readBlocklist']
    }]
  }]
});
const eventFiltersSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Event Filters access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters', {
    defaultMessage: 'Event Filters'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.description', {
    defaultMessage: 'Filter out endpoint events that you do not need or want stored in Elasticsearch.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['event_filters_all',
        // Writing global (not per-policy) Artifacts is gated with Global Artifact Management:ALL starting with siemV3.
        // Users who have been able to write ANY Artifact before are now granted with this privilege to keep existing behavior.
        'global_artifact_management_all']
      }],
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeEventFilters`, `${_constants.APP_ID}-readEventFilters`, `${_constants.APP_ID}-writeGlobalArtifacts`],
      id: 'event_filters_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeEventFilters', 'readEventFilters']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['event_filters_read']
      }],
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEventFilters']
    }]
  }]
});
const policyManagementSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Policy Management access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement', {
    defaultMessage: 'Elastic Defend Policy Management'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.description', {
    defaultMessage: 'Access the Elastic Defend integration policy to configure protections, event collection, and advanced policy features.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['policy_management_all']
      }],
      api: [`${_constants.APP_ID}-writePolicyManagement`, `${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: ['policy-settings-protection-updates-note'],
        read: []
      },
      ui: ['writePolicyManagement', 'readPolicyManagement']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['policy_management_read']
      }],
      api: [`${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: ['policy-settings-protection-updates-note']
      },
      ui: ['readPolicyManagement']
    }]
  }]
});
const responseActionsHistorySubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Response Actions History access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory', {
    defaultMessage: 'Response Actions History'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.description', {
    defaultMessage: 'Access the history of response actions performed on endpoints.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['actions_log_management_all']
      }],
      api: [`${_constants.APP_ID}-writeActionsLogManagement`, `${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeActionsLogManagement', 'readActionsLogManagement']
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['actions_log_management_read']
      }],
      api: [`${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readActionsLogManagement']
    }]
  }]
});
const hostIsolationSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation', {
    defaultMessage: 'Host Isolation'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.description', {
    defaultMessage: 'Perform the "isolate" and "release" response actions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['host_isolation_all']
      }],
      api: [`${_constants.APP_ID}-writeHostIsolationRelease`],
      id: 'host_isolation_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeHostIsolationRelease']
    }]
  }]
});
const processOperationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Process Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations', {
    defaultMessage: 'Process Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.description', {
    defaultMessage: 'Perform process-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['process_operations_all']
      }],
      api: [`${_constants.APP_ID}-writeProcessOperations`],
      id: 'process_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeProcessOperations']
    }]
  }]
});
const fileOperationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for File Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations', {
    defaultMessage: 'File Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.description', {
    defaultMessage: 'Perform file-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['file_operations_all']
      }],
      api: [`${_constants.APP_ID}-writeFileOperations`],
      id: 'file_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeFileOperations']
    }]
  }]
});

// execute operations are not available in 8.7,
// but will be available in 8.8
const executeActionSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Execute Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations', {
    defaultMessage: 'Execute Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.description', {
    defaultMessage: 'Perform script execution response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['execute_operations_all']
      }],
      api: [`${_constants.APP_ID}-writeExecuteOperations`],
      id: 'execute_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeExecuteOperations']
    }]
  }]
});

// 8.15 feature
const scanActionSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Scan Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations', {
    defaultMessage: 'Scan Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations.description', {
    defaultMessage: 'Perform folder scan response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['scan_operations_all']
      }],
      api: [`${_constants.APP_ID}-writeScanOperations`],
      id: 'scan_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeScanOperations']
    }]
  }]
});
const endpointExceptionsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions', {
    defaultMessage: 'Endpoint Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.description', {
    defaultMessage: 'Manage Endpoint Exceptions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['endpoint_exceptions_all',
        // Writing global (not per-policy) Artifacts is gated with Global Artifact Management:ALL starting with siemV3.
        // Users who have been able to write ANY Artifact before are now granted with this privilege to keep existing behavior.
        // This migration is for the serverless offering, where endpoint exception privilege exists.
        'global_artifact_management_all']
      }],
      id: 'endpoint_exceptions_all',
      includeIn: 'all',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['showEndpointExceptions', 'crudEndpointExceptions'],
      api: [`${_constants.APP_ID}-showEndpointExceptions`, `${_constants.APP_ID}-crudEndpointExceptions`, `${_constants.APP_ID}-writeGlobalArtifacts`]
    }, {
      replacedBy: [{
        feature: _constants.SECURITY_FEATURE_ID_V3,
        privileges: ['endpoint_exceptions_read']
      }],
      id: 'endpoint_exceptions_read',
      includeIn: 'read',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['showEndpointExceptions'],
      api: [`${_constants.APP_ID}-showEndpointExceptions`]
    }]
  }]
});

/**
 * Sub-features that will always be available for Security
 * regardless of the product type.
 */
const getSecurityBaseKibanaSubFeatureIds = ({
  experimentalFeatures
}) => [];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getSecurityBaseKibanaSubFeatureIds = getSecurityBaseKibanaSubFeatureIds;
const getSecuritySubFeaturesMap = ({
  experimentalFeatures
}) => {
  const enableSpaceAwarenessIfNeeded = subFeature => {
    if (experimentalFeatures.endpointManagementSpaceAwarenessEnabled) {
      subFeature.requireAllSpaces = false;
      subFeature.privilegesTooltip = undefined;
    }
    return subFeature;
  };
  const securitySubFeaturesList = [[_product_features_keys.SecuritySubFeatureId.endpointList, enableSpaceAwarenessIfNeeded(endpointListSubFeature())], [_product_features_keys.SecuritySubFeatureId.endpointExceptions, enableSpaceAwarenessIfNeeded(endpointExceptionsSubFeature())], [_product_features_keys.SecuritySubFeatureId.trustedApplications, enableSpaceAwarenessIfNeeded(trustedApplicationsSubFeature())], [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptionsBasic, enableSpaceAwarenessIfNeeded(hostIsolationExceptionsBasicSubFeature())], [_product_features_keys.SecuritySubFeatureId.blocklist, enableSpaceAwarenessIfNeeded(blocklistSubFeature())], [_product_features_keys.SecuritySubFeatureId.eventFilters, enableSpaceAwarenessIfNeeded(eventFiltersSubFeature())], [_product_features_keys.SecuritySubFeatureId.policyManagement, enableSpaceAwarenessIfNeeded(policyManagementSubFeature())], [_product_features_keys.SecuritySubFeatureId.responseActionsHistory, enableSpaceAwarenessIfNeeded(responseActionsHistorySubFeature())], [_product_features_keys.SecuritySubFeatureId.hostIsolation, enableSpaceAwarenessIfNeeded(hostIsolationSubFeature())], [_product_features_keys.SecuritySubFeatureId.processOperations, enableSpaceAwarenessIfNeeded(processOperationsSubFeature())], [_product_features_keys.SecuritySubFeatureId.fileOperations, enableSpaceAwarenessIfNeeded(fileOperationsSubFeature())], [_product_features_keys.SecuritySubFeatureId.executeAction, enableSpaceAwarenessIfNeeded(executeActionSubFeature())], [_product_features_keys.SecuritySubFeatureId.scanAction, enableSpaceAwarenessIfNeeded(scanActionSubFeature())]];

  // Use the following code to add feature based on feature flag
  // if (experimentalFeatures.featureFlagName) {
  //   securitySubFeaturesList.push([SecuritySubFeatureId.featureId, featureSubFeature]);
  // }

  const securitySubFeaturesMap = new Map(securitySubFeaturesList);
  return Object.freeze(securitySubFeaturesMap);
};
exports.getSecuritySubFeaturesMap = getSecuritySubFeaturesMap;