"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAuthentication = exports.AuthenticationProvider = void 0;
exports.useCurrentUser = useCurrentUser;
exports.useUserProfile = useUserProfile;
var _constate = _interopRequireDefault(require("constate"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const [AuthenticationProvider, useAuthentication] = (0, _constate.default)(({
  authc
}) => authc);
exports.useAuthentication = useAuthentication;
exports.AuthenticationProvider = AuthenticationProvider;
function useCurrentUser() {
  const authc = useAuthentication();
  return (0, _useAsync.default)(authc.getCurrentUser, [authc]);
}
function useUserProfile(dataPath) {
  const {
    userProfiles
  } = (0, _.useSecurityApiClients)();
  const dataUpdateState = (0, _useObservable.default)(userProfiles.dataUpdates$);
  return (0, _useAsync.default)(() => userProfiles.getCurrent(dataPath ? {
    dataPath
  } : undefined), [userProfiles, dataUpdateState]);
}