"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceIndicesFields = void 0;
var _reactHookForm = require("react-hook-form");
var _react = require("react");
var _use_indices_fields = require("./use_indices_fields");
var _types = require("../types");
var _use_usage_tracker = require("./use_usage_tracker");
var _constants = require("../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourceIndicesFields = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    field: {
      value: selectedIndices,
      onChange: onIndicesChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.indices
  });
  const {
    field: {
      onChange: onUserQueryChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.userElasticsearchQuery
  });
  const {
    fields,
    isLoading: isFieldsLoading
  } = (0, _use_indices_fields.useIndicesFields)(selectedIndices);
  const addIndex = (0, _react.useCallback)(newIndex => {
    const newIndices = [...selectedIndices, newIndex];
    onIndicesChange(newIndices);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceIndexUpdated, newIndices.length);
  }, [onIndicesChange, selectedIndices, usageTracker]);
  const removeIndex = (0, _react.useCallback)(index => {
    const newIndices = selectedIndices.filter(indexName => indexName !== index);
    onIndicesChange(newIndices);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceIndexUpdated, newIndices.length);
  }, [onIndicesChange, selectedIndices, usageTracker]);
  const setIndices = (0, _react.useCallback)(indices => {
    onIndicesChange(indices);
    onUserQueryChange(null);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceIndexUpdated, indices.length);
  }, [onIndicesChange, onUserQueryChange, usageTracker]);
  return {
    indices: selectedIndices,
    fields,
    isFieldsLoading,
    addIndex,
    removeIndex,
    setIndices
  };
};
exports.useSourceIndicesFields = useSourceIndicesFields;