"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetrievalDocsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESULT_FIELDS_TRUNCATE_AT = 4;
const truncateFields = doc => Object.entries({
  context: doc.content,
  score: doc.metadata._score
}).slice(0, RESULT_FIELDS_TRUNCATE_AT).map(([field, value]) => ({
  field,
  value
}));
const RetrievalDocsFlyout = ({
  onClose,
  retrievalDocs
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const columns = [{
    field: 'field',
    name: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.nameColumn', {
      defaultMessage: 'Field'
    }),
    render: field => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("code", null, "\"", field, "\"")));
    },
    truncateText: true,
    width: '20%'
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.valueColumn', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "none",
      transparentBackground: true,
      fontSize: "m"
    }, value)
  }];
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.retrievalDocsFlyoutOpened);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.title', {
    defaultMessage: 'Documents retrieved'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.subtitle', {
    defaultMessage: 'The documents that were referenced in order to create an answer to your query. You can change the context field using the Edit context button.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, retrievalDocs.map(doc => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    key: doc.metadata._id,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement("code", null, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.id', {
    defaultMessage: 'ID: {id}',
    values: {
      id: doc.metadata._id
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement("code", null, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.retrievalDoc.result.fromIndex', {
    defaultMessage: 'from'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, doc.metadata._index)))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: truncateFields(doc),
    columns: columns
  })))))));
};
exports.RetrievalDocsFlyout = RetrievalDocsFlyout;