"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Term = ({
  label
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, label, ":")));
const Definition = ({
  label
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued"
}, label));
const MetadataPopover = ({
  id,
  onDocumentDelete
}) => {
  const [popoverIsOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const closePopover = () => setPopoverIsOpen(false);
  const metaDataIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "empty",
    size: "xs",
    iconType: "info",
    color: "primary",
    onClick: () => setPopoverIsOpen(!popoverIsOpen),
    "aria-label": _i18n.i18n.translate('xpack.searchIndexDocuments.result.header.metadata.icon.ariaLabel', {
      defaultMessage: 'Metadata for document: {id}',
      values: {
        id
      }
    })
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: metaDataIcon,
    isOpen: popoverIsOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('xpack.searchIndexDocuments.result.header.metadata.title', {
    defaultMessage: 'Document metadata'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    style: {
      width: '20rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(Term, {
    label: "ID"
  }), /*#__PURE__*/_react.default.createElement(Definition, {
    label: id
  })))), onDocumentDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    color: "danger",
    size: "s",
    onClick: closePopover,
    fullWidth: true
  }, _i18n.i18n.translate('xpack.searchIndexDocuments.result.header.metadata.deleteDocument', {
    defaultMessage: 'Delete document'
  }))));
};
const ResultHeader = ({
  title,
  metaData
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "resultHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, title))), !!metaData && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MetadataPopover, metaData))));
};
exports.ResultHeader = ResultHeader;