"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectSaveModalOrigin = SavedObjectSaveModalOrigin;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SavedObjectSaveModalOrigin(props) {
  const [returnToOriginMode, setReturnToOriginMode] = (0, _react.useState)(Boolean(props.originatingApp));
  const {
    documentInfo
  } = props;
  const returnLabel = _i18n.i18n.translate('savedObjects.saveModalOrigin.returnToOriginLabel', {
    defaultMessage: 'Return'
  });
  const addLabel = _i18n.i18n.translate('savedObjects.saveModalOrigin.addToOriginLabel', {
    defaultMessage: 'Add'
  });
  const getReturnToOriginSwitch = state => {
    const sourceOptions = typeof props.options === 'function' ? props.options(state) : props.options;
    if (!props.originatingApp) {
      return sourceOptions;
    }
    const origin = props.getAppNameFromId ? props.getAppNameFromId(props.originatingApp) || props.originatingApp : props.originatingApp;
    if (!state.copyOnSave || props.originatingApp === 'dashboards' // dashboard supports adding a copied panel on save...
    ) {
      var _props$returnToOrigin;
      const originVerb = !documentInfo.id || state.copyOnSave ? addLabel : returnLabel;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, sourceOptions, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "returnToOriginModeSwitch",
        checked: returnToOriginMode,
        onChange: event => {
          setReturnToOriginMode(event.target.checked);
        },
        label: (_props$returnToOrigin = props.returnToOriginSwitchLabel) !== null && _props$returnToOrigin !== void 0 ? _props$returnToOrigin : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModalOrigin.originAfterSavingSwitchLabel",
          defaultMessage: "{originVerb} to {origin} after saving",
          values: {
            originVerb,
            origin
          }
        })
      })));
    } else {
      setReturnToOriginMode(false);
      return sourceOptions;
    }
  };
  const onModalSave = async onSaveProps => {
    return props.onSave({
      ...onSaveProps,
      returnToOrigin: returnToOriginMode
    });
  };
  const confirmButtonLabel = returnToOriginMode ? _i18n.i18n.translate('savedObjects.saveModalOrigin.saveAndReturnLabel', {
    defaultMessage: 'Save and return'
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_.SavedObjectSaveModalWithSaveResult, {
    onSave: onModalSave,
    onClose: props.onClose,
    title: documentInfo.title,
    showCopyOnSave: documentInfo.id ? true : false,
    initialCopyOnSave: Boolean(documentInfo.id) && returnToOriginMode,
    confirmButtonLabel: confirmButtonLabel,
    objectType: props.objectType,
    options: getReturnToOriginSwitch,
    description: documentInfo.description,
    showDescription: true
  });
}