"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryItem = SummaryItem;
exports.getValueLable = getValueLable;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Title({
  title,
  size
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    textAlign: "left",
    size: size
  }, title);
}
function BaseValue({
  id,
  value,
  icon,
  color
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `${id}_${icon}_${color}`,
    type: icon,
    color: color,
    size: "l"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    style: {
      fontWeight: 'bold'
    },
    color: color,
    "data-test-subj": `${id}_value`
  }, value)));
}
function getValueLable(value, perc) {
  return perc ? `${value} (${perc})` : `${value}`;
}
function SummaryItem({
  id,
  baseValue,
  baseColor,
  comparisonValue,
  title,
  isLoading,
  comparisonPerc,
  comparisonColor,
  titleHint,
  hasBorder = false,
  compressed = false
}) {
  const textSize = compressed ? 's' : 'm';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: hasBorder
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: /*#__PURE__*/_react.default.createElement(BaseValue, {
      id: id,
      value: baseValue,
      color: baseColor
    }),
    titleSize: textSize,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, titleHint ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(Title, {
      title: title,
      size: textSize
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: titleHint,
      type: "question"
    }))) : /*#__PURE__*/_react.default.createElement(Title, {
      title: title,
      size: textSize
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)),
    textAlign: "right",
    isLoading: isLoading
  }, !isLoading && comparisonValue ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: comparisonColor,
    size: textSize
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `${id}_comparison_value`
  }, getValueLable(comparisonValue, comparisonPerc))) : null));
}