"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = Editor;
var _react = _interopRequireDefault(require("react"));
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Editor({
  code,
  onChange,
  context
}) {
  const suggestionProvider = _monaco.PainlessLang.getSuggestionProvider(context);
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.PainlessLang.ID
    // 99% width allows the editor to resize horizontally. 100% prevents it from resizing.
    ,
    width: "99%",
    height: "100%",
    value: code,
    onChange: onChange,
    suggestionProvider: suggestionProvider,
    options: {
      fontSize: 12,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true,
      suggest: {
        snippetsPreventQuickSuggestions: false
      }
    }
  });
}