"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConversationTitle = void 0;
var _zod = require("@kbn/zod");
var _utils = require("../../agents/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConversationTitle = async ({
  previousRounds,
  nextInput,
  chatModel
}) => {
  const structuredModel = chatModel.withStructuredOutput(_zod.z.object({
    title: _zod.z.string().describe('The title for the conversation')
  }));
  const prompt = [['system', "'You are a helpful assistant. Assume the following messages is the start of a conversation between you and a user; give this conversation a title based on the content below"], ...(0, _utils.conversationToLangchainMessages)({
    previousRounds,
    nextInput
  })];
  const {
    title
  } = await structuredModel.invoke(prompt);
  return title;
};
exports.generateConversationTitle = generateConversationTitle;