"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertGraphEvents = void 0;
var _rxjs = require("rxjs");
var _agents = require("@kbn/onechat-common/agents");
var _tools = require("@kbn/onechat-common/tools");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertGraphEvents = ({
  graphName,
  toolIdMapping,
  runName
}) => {
  return streamEvents$ => {
    const toolCallIdToIdMap = new Map();
    return streamEvents$.pipe((0, _rxjs.mergeMap)(event => {
      if (!(0, _langchain.matchGraphName)(event, graphName)) {
        return _rxjs.EMPTY;
      }

      // emit reasoning events
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'reason')) {
        const state = event.data.output;
        const reasoningEvents = state.addedMessages.filter(_actions.isReasoningStep);
        const lastReasoningEvent = reasoningEvents[reasoningEvents.length - 1];
        return (0, _rxjs.of)((0, _langchain.createReasoningEvent)(lastReasoningEvent.reasoning));
      }

      // stream text chunks for the UI
      if ((0, _langchain.matchEvent)(event, 'on_chat_model_stream') && (0, _langchain.hasTag)(event, 'reasoning:act')) {
        const chunk = event.data.chunk;
        const textContent = (0, _langchain.extractTextContent)(chunk);
        if (textContent) {
          return (0, _rxjs.of)((0, _langchain.createTextChunkEvent)(chunk));
        }
      }

      // emit tool calls or full message on each agent step
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'act')) {
        const state = event.data.output;
        const addedMessages = state.addedMessages.filter(_actions.isMessage);
        const lastMessage = addedMessages[addedMessages.length - 1];
        const toolCalls = (0, _langchain.extractToolCalls)(lastMessage);
        if (toolCalls.length > 0) {
          const toolCallEvents = [];
          for (const toolCall of toolCalls) {
            const toolId = (0, _langchain.toolIdentifierFromToolCall)(toolCall, toolIdMapping);
            toolCallIdToIdMap.set(toolCall.toolCallId, toolId);
            toolCallEvents.push({
              type: _agents.ChatAgentEventType.toolCall,
              data: {
                toolId,
                toolCallId: toolCall.toolCallId,
                args: toolCall.args
              }
            });
          }
          return (0, _rxjs.of)(...toolCallEvents);
        } else {
          var _lastMessage$id;
          const messageEvent = {
            type: _agents.ChatAgentEventType.messageComplete,
            data: {
              messageId: (_lastMessage$id = lastMessage.id) !== null && _lastMessage$id !== void 0 ? _lastMessage$id : 'unknown',
              messageContent: (0, _langchain.extractTextContent)(lastMessage)
            }
          };
          return (0, _rxjs.of)(messageEvent);
        }
      }

      // emit tool result events
      if ((0, _langchain.matchEvent)(event, 'on_chain_end') && (0, _langchain.matchName)(event, 'tools')) {
        var _event$data$output$ad;
        const toolMessages = (_event$data$output$ad = event.data.output.addedMessages) !== null && _event$data$output$ad !== void 0 ? _event$data$output$ad : [];
        const toolResultEvents = [];
        for (const toolMessage of toolMessages) {
          const toolId = toolCallIdToIdMap.get(toolMessage.tool_call_id);
          toolResultEvents.push({
            type: _agents.ChatAgentEventType.toolResult,
            data: {
              toolCallId: toolMessage.tool_call_id,
              toolId: toolId !== null && toolId !== void 0 ? toolId : (0, _tools.toStructuredToolIdentifier)('unknown'),
              result: (0, _langchain.extractTextContent)(toolMessage)
            }
          });
        }
        return (0, _rxjs.of)(...toolResultEvents);
      }

      // run is finished
      // if (event.event === 'on_chain_end' && event.name === runName) {}

      return _rxjs.EMPTY;
    }));
  };
};
exports.convertGraphEvents = convertGraphEvents;