"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runChatAgent = void 0;
var _uuid = require("uuid");
var _rxjs = require("rxjs");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
var _utils = require("../utils");
var _graph = require("./graph");
var _convert_graph_events = require("./convert_graph_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chatAgentGraphName = 'default-onechat-agent';
/**
 * Create the handler function for the default onechat agent.
 */
const runChatAgent = async ({
  nextInput,
  conversation = [],
  tools = [],
  runId = (0, _uuid.v4)(),
  systemPrompt
}, {
  logger,
  request,
  modelProvider,
  events
}) => {
  const model = await modelProvider.getDefaultModel();
  const {
    tools: langchainTools,
    idMappings: toolIdMapping
  } = await (0, _langchain.toolsToLangchain)({
    tools,
    logger,
    request
  });
  const initialMessages = (0, _utils.conversationToLangchainMessages)({
    nextInput,
    previousRounds: conversation
  });
  const agentGraph = await (0, _graph.createAgentGraph)({
    logger,
    chatModel: model.chatModel,
    tools: langchainTools,
    systemPrompt
  });
  const eventStream = agentGraph.streamEvents({
    initialMessages
  }, {
    version: 'v2',
    runName: chatAgentGraphName,
    metadata: {
      graphName: chatAgentGraphName,
      runId
    },
    recursionLimit: 10,
    callbacks: []
  });
  const events$ = (0, _rxjs.from)(eventStream).pipe((0, _rxjs.filter)(_langchain.isStreamEvent), (0, _convert_graph_events.convertGraphEvents)({
    graphName: chatAgentGraphName,
    toolIdMapping
  }), (0, _utils.addRoundCompleteEvent)({
    userInput: nextInput
  }), (0, _rxjs.shareReplay)());
  events$.subscribe(event => {
    events.emit(event);
  });
  const round = await (0, _utils.extractRound)(events$);
  return {
    round
  };
};
exports.runChatAgent = runChatAgent;