"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _sseUtilsClient = require("@kbn/sse-utils-client");
var _errors = require("../utils/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChatService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  chat({
    agentId,
    connectorId,
    conversationId,
    nextMessage,
    mode
  }) {
    return (0, _rxjs.defer)(() => {
      return this.http.post('/internal/onechat/chat?stream=true', {
        asResponse: true,
        rawResponse: true,
        body: JSON.stringify({
          agentId,
          mode,
          connectorId,
          conversationId,
          nextMessage
        })
      });
    }).pipe(
    // @ts-expect-error SseEvent mixin issue
    (0, _sseUtilsClient.httpResponseIntoObservable)(), (0, _errors.unwrapOnechatErrors)());
  }
}
exports.ChatService = ChatService;