"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register = require("./register");
var _services = require("./services");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    this.logger = context.logger.get();
  }
  setup(core) {
    const isOnechatUiEnabled = core.uiSettings.get(_constants.ONECHAT_UI_SETTING_ID, false);
    if (isOnechatUiEnabled) {
      (0, _register.registerApp)({
        core,
        getServices: () => {
          if (!this.internalServices) {
            throw new Error('getServices called before plugin start');
          }
          return this.internalServices;
        }
      });
    }
    return {};
  }
  start({
    http
  }, pluginsStart) {
    const agentService = new _services.AgentService({
      http
    });
    const chatService = new _services.ChatService({
      http
    });
    const conversationsService = new _services.ConversationsService({
      http
    });
    const toolsService = new _services.ToolsService({
      http
    });
    this.internalServices = {
      agentService,
      chatService,
      conversationsService,
      toolsService
    };
    return {};
  }
}
exports.OnechatPlugin = OnechatPlugin;