"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relevanceSearch = void 0;
var _index_explorer = require("./index_explorer");
var _utils = require("./utils");
var _steps = require("./steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const relevanceSearch = async ({
  term,
  index,
  fields = [],
  size = 10,
  model,
  esClient
}) => {
  let selectedIndex = index;
  let selectedFields = [];

  // if no index was specified, we use the index explorer to select the best one
  if (!selectedIndex) {
    const {
      indices
    } = await (0, _index_explorer.indexExplorer)({
      query: term,
      esClient,
      model
    });
    if (indices.length === 0) {
      return {
        results: []
      };
    }
    selectedIndex = indices[0].indexName;
  }
  const mappings = await (0, _steps.getIndexMappings)({
    indices: [selectedIndex],
    esClient
  });
  const flattenedFields = (0, _utils.flattenMappings)(mappings[selectedIndex]);
  if (fields.length) {
    selectedFields = flattenedFields.filter(field => fields.includes(field.path)).filter(field => field.type === 'text' || field.type === 'semantic_text');
  }
  if (selectedFields.length === 0) {
    selectedFields = flattenedFields.filter(field => field.type === 'text' || field.type === 'semantic_text');
  }
  return (0, _steps.performMatchSearch)({
    term,
    fields: selectedFields,
    index: selectedIndex,
    size,
    esClient
  });
};
exports.relevanceSearch = relevanceSearch;